/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.util.BlockCoord;
import CoroUtil.util.Vec3;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CoroUtilEntity {
    public static boolean canCoordBeSeen(EntityLivingBase ent, int x, int y, int z) {
        return ent.field_70170_p.func_72933_a(new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v), new Vec3d((double)x, (double)y, (double)z)) == null;
    }

    public static boolean canCoordBeSeenFromFeet(EntityLivingBase ent, int x, int y, int z) {
        return ent.field_70170_p.func_72933_a(new Vec3d(ent.field_70165_t, ent.func_174813_aQ().field_72338_b + 0.15, ent.field_70161_v), new Vec3d((double)x, (double)y, (double)z)) == null;
    }

    public static double getDistance(Entity ent, BlockCoord coords) {
        double d3 = ent.field_70165_t - (double)coords.posX;
        double d4 = ent.field_70163_u - (double)coords.posY;
        double d5 = ent.field_70161_v - (double)coords.posZ;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public static double getDistance(Entity ent, TileEntity tEnt) {
        double d3 = ent.field_70165_t - (double)tEnt.func_174877_v().func_177958_n();
        double d4 = ent.field_70163_u - (double)tEnt.func_174877_v().func_177956_o();
        double d5 = ent.field_70161_v - (double)tEnt.func_174877_v().func_177952_p();
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public static Vec3 getTargetVector(EntityLivingBase parEnt, EntityLivingBase target) {
        double vecX = target.field_70165_t - parEnt.field_70165_t;
        double vecY = target.field_70163_u - parEnt.field_70163_u;
        double vecZ = target.field_70161_v - parEnt.field_70161_v;
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        Vec3 vec3 = new Vec3(vecX / dist, vecY / dist, vecZ / dist);
        return vec3;
    }

    public static void moveTowards(Entity ent, Entity targ, float speed) {
        double vecX = targ.field_70165_t - ent.field_70165_t;
        double vecY = targ.field_70163_u - ent.field_70163_u;
        double vecZ = targ.field_70161_v - ent.field_70161_v;
        double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        ent.field_70159_w += vecX / dist2 * (double)speed;
        ent.field_70181_x += vecY / dist2 * (double)speed;
        ent.field_70179_y += vecZ / dist2 * (double)speed;
    }

    public static String getName(Entity ent) {
        return ent != null ? ent.func_70005_c_() : "nullObject";
    }

    public static EntityPlayer getPlayerByUUID(UUID uuid) {
        for (EntityPlayerMP entityplayermp : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!entityplayermp.func_146103_bH().getId().equals(uuid)) continue;
            return entityplayermp;
        }
        return null;
    }

    public static EntityPlayer getClosestVulnerablePlayerToEntity(World world, Entity p_72856_1_, double p_72856_2_) {
        return CoroUtilEntity.getClosestVulnerablePlayer(world, p_72856_1_.field_70165_t, p_72856_1_.field_70163_u, p_72856_1_.field_70161_v, p_72856_2_);
    }

    public static EntityPlayer getClosestVulnerablePlayer(World world, double p_72846_1_, double p_72846_3_, double p_72846_5_, double p_72846_7_) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)world.field_73010_i.get(i);
            if (entityplayer1.field_71075_bZ.field_75102_a || !entityplayer1.func_70089_S()) continue;
            double d5 = entityplayer1.func_70092_e(p_72846_1_, p_72846_3_, p_72846_5_);
            double d6 = p_72846_7_;
            if (entityplayer1.func_70093_af()) {
                d6 = p_72846_7_ * (double)0.8f;
            }
            if (entityplayer1.func_82150_aj()) {
                float f = entityplayer1.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d6 *= (double)(0.7f * f);
            }
            if (!(p_72846_7_ < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }
}

