/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world;

import CoroUtil.config.ConfigCoroAI;
import CoroUtil.event.WorldEvent;
import CoroUtil.pathfinding.PathPointEx;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.chunk.ChunkDataPoint;
import CoroUtil.world.grid.chunk.PlayerDataGrid;
import CoroUtil.world.location.ISimulationTickable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class WorldDirector
implements Runnable {
    public int dimID = -1;
    public String modID = "modID";
    public String type = "default";
    public int cachedTopBlockHome = -1;
    private NBTTagCompound extraData = new NBTTagCompound();
    public List<WorldEvent> worldEvents = new ArrayList<WorldEvent>();
    public ConcurrentHashMap<Integer, ISimulationTickable> lookupTickingManagedLocations;
    public List<ISimulationTickable> listTickingLocations;
    public boolean useThreading = false;
    public Thread threadedDirector = null;
    private boolean threadRunning = false;
    public int threadSleepRate = 1000;
    public boolean threadServerSideOnly = true;
    public HashMap<String, Integer> lookupNameToUpdatesPerTickCur = new HashMap();
    public HashMap<String, Integer> lookupNameToUpdatesPerTickLimit = new HashMap();

    public WorldDirector(boolean runThread) {
        this();
        this.useThreading = runThread;
    }

    public WorldDirector() {
        this.lookupTickingManagedLocations = new ConcurrentHashMap();
        this.listTickingLocations = new ArrayList<ISimulationTickable>();
    }

    public void initAndStartThread() {
        if (!this.threadRunning) {
            this.threadRunning = true;
            this.threadedDirector = new Thread((Runnable)this, "World Simulation Thread");
            this.threadedDirector.start();
        } else {
            System.out.println("tried to start thread when already running for CoroUtil world director");
        }
    }

    public void stopThread() {
        this.threadRunning = false;
    }

    public void initData(String parModID, World parWorld) {
        this.dimID = parWorld.field_73011_w.getDimension();
        this.modID = parModID;
        if (!(!this.useThreading || parWorld.field_72995_K && this.threadServerSideOnly)) {
            this.initAndStartThread();
        }
    }

    public World getWorld() {
        WorldServer world = DimensionManager.getWorld((int)this.dimID);
        return world;
    }

    public NBTTagCompound getExtraData() {
        return this.extraData;
    }

    public void reset() {
        this.extraData = new NBTTagCompound();
        this.cachedTopBlockHome = -1;
        this.worldEvents.clear();
    }

    public void addEvent(WorldEvent event) {
        this.worldEvents.add(event);
        event.init();
    }

    public void addTickingLocation(ISimulationTickable location) {
        this.addTickingLocation(location, true);
    }

    public void addTickingLocation(ISimulationTickable location, boolean init) {
        if (location.getOrigin() != null) {
            Integer hash = PathPointEx.makeHash(location.getOrigin().posX, location.getOrigin().posY, location.getOrigin().posZ);
            if (!this.lookupTickingManagedLocations.containsKey(hash)) {
                this.lookupTickingManagedLocations.put(hash, location);
            } else {
                System.out.println("warning: location already exists at these coords: " + location.getOrigin());
            }
        }
        this.listTickingLocations.add(location);
    }

    public void removeTickingLocation(ISimulationTickable location) {
        if (location.getOrigin() != null) {
            Integer hash = PathPointEx.makeHash(location.getOrigin().posX, location.getOrigin().posY, location.getOrigin().posZ);
            if (this.lookupTickingManagedLocations.containsKey(hash)) {
                this.lookupTickingManagedLocations.remove(hash);
                location.cleanup();
            } else {
                System.out.println("Error, couldnt find location for removal");
            }
        }
        this.listTickingLocations.remove(location);
    }

    public void setSharedSimulationUpdateRateLimit(String name, int limit) {
        this.lookupNameToUpdatesPerTickLimit.put(name, limit);
    }

    public int getSharedSimulationUpdateRateLimit(String name) {
        return this.lookupNameToUpdatesPerTickLimit.get(name);
    }

    public int getSharedSimulationUpdateRateCurrent(String name) {
        if (!this.lookupNameToUpdatesPerTickCur.containsKey(name)) {
            this.lookupNameToUpdatesPerTickCur.put(name, 0);
        }
        return this.lookupNameToUpdatesPerTickCur.get(name);
    }

    public void setSharedSimulationUpdateRateCurrent(String name, int cur) {
        this.lookupNameToUpdatesPerTickCur.put(name, cur);
    }

    public ISimulationTickable getTickingSimluationByLocation(BlockCoord parCoords) {
        Integer hash = PathPointEx.makeHash(parCoords.posX, parCoords.posY, parCoords.posZ);
        return this.lookupTickingManagedLocations.get(hash);
    }

    public void tick() {
        for (int i = 0; i < this.worldEvents.size(); ++i) {
            WorldEvent event = this.worldEvents.get(i);
            if (!event.isComplete()) continue;
            event.cleanup();
            this.worldEvents.remove(i--);
        }
        this.lookupNameToUpdatesPerTickCur.clear();
        for (ISimulationTickable entry : this.listTickingLocations) {
            entry.tickUpdate();
        }
        World world = this.getWorld();
        if (ConfigCoroAI.trackPlayerData && world.func_82737_E() % PlayerDataGrid.playerTimeSpentUpdateInterval == 0L) {
            for (int i = 0; i < world.field_73010_i.size(); ++i) {
                EntityPlayer entP = (EntityPlayer)world.field_73010_i.get(i);
                ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(world).getChunkData(MathHelper.func_76128_c((double)entP.field_70165_t) / 16, MathHelper.func_76128_c((double)entP.field_70161_v) / 16);
                cdp.addToPlayerActivityTime(entP.func_146103_bH().getId(), PlayerDataGrid.playerTimeSpentUpdateInterval);
            }
        }
    }

    public boolean isCoordAndNearAreaNaturalBlocks(World parWorld, int x, int y, int z, int range) {
        return this.isNaturalSurfaceBlock(parWorld.func_180495_p(new BlockPos(x, y, z)).func_177230_c()) && this.isNaturalSurfaceBlock(parWorld.func_180495_p(new BlockPos(x + range, y, z)).func_177230_c()) && this.isNaturalSurfaceBlock(parWorld.func_180495_p(new BlockPos(x - range, y, z)).func_177230_c()) && this.isNaturalSurfaceBlock(parWorld.func_180495_p(new BlockPos(x, y, z + range)).func_177230_c()) && this.isNaturalSurfaceBlock(parWorld.func_180495_p(new BlockPos(x, y, z - range)).func_177230_c());
    }

    public boolean isNaturalSurfaceBlock(Block id) {
        if (id == Blocks.field_150433_aE || id == Blocks.field_150349_c || id == Blocks.field_150346_d || id == Blocks.field_150354_m || id == Blocks.field_150348_b || id == Blocks.field_150351_n || id == Blocks.field_150329_H) {
            return true;
        }
        return this.isLogOrLeafBlock(id);
    }

    public boolean isLogOrLeafBlock(Block id) {
        Block block = id;
        if (block == null) {
            return false;
        }
        if (block.func_149688_o(block.func_176223_P()) == Material.field_151584_j) {
            return true;
        }
        if (block.func_149688_o(block.func_176223_P()) == Material.field_151585_k) {
            return true;
        }
        return block.func_149688_o(block.func_176223_P()) == Material.field_151575_d;
    }

    public int getTopGroundBlock(World world, int x, int startY, int z) {
        int safetyCount = 0;
        for (int curY = startY; curY > 0 && safetyCount++ < 300; --curY) {
            Block id = world.func_180495_p(new BlockPos(x, curY, z)).func_177230_c();
            if (!this.isNaturalSurfaceBlock(id)) continue;
            return curY;
        }
        return 1;
    }

    public void tryReadFromFile() {
        this.readFromFile();
    }

    private void readFromFile() {
        try {
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator + "World" + File.separator;
            String fullPath = saveFolder + "WorldData_" + this.modID + "_" + this.dimID + "_" + this.type + ".dat";
            if (new File(fullPath).exists()) {
                this.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(fullPath)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeToFile(boolean unloadInstances) {
        if (unloadInstances) {
            this.stopThread();
        }
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            boolean bool = false;
            if (this.extraData != null) {
                bool = this.extraData.func_74767_n("generatedTown");
            }
            this.writeToNBT(nbt);
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator + "World" + File.separator;
            if (!new File(saveFolder).exists()) {
                new File(saveFolder).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(saveFolder + "WorldData_" + this.modID + "_" + this.dimID + "_" + this.type + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readFromNBT(NBTTagCompound parData) {
        this.extraData = parData.func_74775_l("extraData");
        NBTTagCompound tickingLocations = parData.func_74775_l("tickingLocations");
        for (String keyName : tickingLocations.func_150296_c()) {
            NBTTagCompound nbt = tickingLocations.func_74775_l(keyName);
            String classname = nbt.func_74779_i("classname");
            ClassLoader classLoader = WorldDirector.class.getClassLoader();
            Class<?> aClass = null;
            try {
                aClass = classLoader.loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ISimulationTickable locationObj = null;
            if (aClass != null) {
                try {
                    locationObj = (ISimulationTickable)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (locationObj == null) continue;
            locationObj.init();
            locationObj.readFromNBT(nbt);
            locationObj.initPost();
            this.addTickingLocation(locationObj);
        }
    }

    public void writeToNBT(NBTTagCompound parData) {
        NBTTagCompound nbtSet = new NBTTagCompound();
        int index = 0;
        for (ISimulationTickable entry : this.listTickingLocations) {
            NBTTagCompound nbt = new NBTTagCompound();
            entry.writeToNBT(nbt);
            nbtSet.func_74782_a("" + index++, (NBTBase)nbt);
        }
        parData.func_74782_a("tickingLocations", (NBTBase)nbtSet);
        parData.func_74778_a("classname", this.getClass().getCanonicalName());
        parData.func_74782_a("extraData", (NBTBase)this.extraData);
    }

    @Override
    public void run() {
        while (this.threadRunning) {
            try {
                for (ISimulationTickable entry : this.listTickingLocations) {
                    if (!entry.isThreaded()) continue;
                    entry.tickUpdateThreaded();
                }
                Thread.sleep(this.threadSleepRate);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stopThread();
            }
        }
    }
}

