/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.grid.block;

import CoroUtil.world.grid.block.BlockDataGrid;
import CoroUtil.world.grid.block.BlockStaticDataMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class BlockDataPoint {
    public BlockDataGrid grid;
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public final int hash;
    public float health;
    public long lastTickTime;
    public float walkedOnAmount;
    public byte creationType;
    public Block blockID;
    public int blockMeta;
    public static byte CREATETYPE_UNKNOWN = 0;
    public static byte CREATETYPE_EPOCH = 1;
    public static byte CREATETYPE_PLAYER = (byte)2;

    public BlockDataPoint(BlockDataGrid parGrid, int i, int j, int k) {
        this.grid = parGrid;
        this.xCoord = i;
        this.yCoord = j;
        this.zCoord = k;
        this.hash = BlockDataPoint.makeHash(i, j, k);
        this.updateCache();
        this.health = BlockStaticDataMap.getBlockMaxHealth(this.blockID);
    }

    public void updateCache() {
        IBlockState state = this.grid.world.func_180495_p(new BlockPos(this.xCoord, this.yCoord, this.zCoord));
        this.blockID = state.func_177230_c();
        this.blockMeta = state.func_177230_c().func_176201_c(state);
    }

    public boolean isRemovable() {
        if (this.health < BlockStaticDataMap.getBlockMaxHealth(this.blockID)) {
            return false;
        }
        if (this.walkedOnAmount > 0.0f) {
            return false;
        }
        return this.creationType <= 0;
    }

    public static int makeHash(int i, int j, int k) {
        return j & 0xFF | (i & Short.MAX_VALUE) << 8 | (k & Short.MAX_VALUE) << 24 | (i >= 0 ? 0 : Integer.MIN_VALUE) | (k >= 0 ? 0 : 32768);
    }

    public float distanceTo(BlockDataPoint pathpoint) {
        float f = pathpoint.xCoord - this.xCoord;
        float f1 = pathpoint.yCoord - this.yCoord;
        float f2 = pathpoint.zCoord - this.zCoord;
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockDataPoint) {
            BlockDataPoint pathpoint = (BlockDataPoint)obj;
            return this.hash == pathpoint.hash && this.xCoord == pathpoint.xCoord && this.yCoord == pathpoint.yCoord && this.zCoord == pathpoint.zCoord;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.xCoord + ", " + this.yCoord + ", " + this.zCoord;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.blockID = Block.func_149729_e((int)nbt.func_74762_e("blockID"));
        this.blockMeta = nbt.func_74762_e("blockMeta");
        this.health = nbt.func_74760_g("health");
        this.lastTickTime = nbt.func_74763_f("lastTickTime");
        this.creationType = nbt.func_74771_c("creationType");
        this.walkedOnAmount = nbt.func_74760_g("walkedOnAmount");
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("blockID", Block.func_149682_b((Block)this.blockID));
        nbt.func_74768_a("blockMeta", this.blockMeta);
        nbt.func_74776_a("health", this.health);
        nbt.func_74772_a("lastTickTime", this.lastTickTime);
        nbt.func_74774_a("creationType", this.creationType);
        nbt.func_74776_a("walkedOnAmount", this.walkedOnAmount);
        nbt.func_74768_a("xCoord", this.xCoord);
        nbt.func_74768_a("yCoord", this.yCoord);
        nbt.func_74768_a("zCoord", this.zCoord);
        return nbt;
    }

    public void tickUpdate() {
        long curTickTime;
        this.lastTickTime = curTickTime = this.grid.world.func_82737_E();
    }

    public void cleanup() {
        this.grid = null;
    }
}

