/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import CoroUtil.api.weather.IWindHandler;
import CoroUtil.util.Vec3;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import java.util.List;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityRotFX
extends Particle
implements IWindHandler {
    public boolean weatherEffect = false;
    public float spawnY = -1.0f;
    public int particleTextureIndexInt = 0;
    public float brightness = 0.7f;
    public ParticleBehaviors pb = null;
    public boolean callUpdateSuper = true;
    public boolean callUpdatePB = true;
    public float renderRange = 128.0f;
    public int renderOrder = 0;
    private int entityID = 0;
    public int debugID = 0;
    public float rotationYaw;
    public float rotationPitch;
    public float windWeight = 5.0f;
    public int particleDecayExtra = 0;
    public boolean isTransparent = true;
    public boolean killOnCollide = false;
    public boolean facePlayer = false;
    public boolean vanillaMotionDampen = true;
    public double aboveGroundHeight = 4.5;
    public boolean checkAheadToBounce = true;
    public boolean collisionSpeedDampen = true;
    public double bounceSpeed = 0.05;
    public double bounceSpeedMax = 0.15;
    public double bounceSpeedAhead = 0.35;
    public double bounceSpeedMaxAhead = 0.25;
    public boolean spinFast = false;
    private float ticksFadeInMax = 0.0f;
    private float ticksFadeOutMax = 0.0f;
    private boolean dontRenderUnderTopmostBlock = false;
    private boolean killWhenUnderTopmostBlock = false;
    private float ticksFadeOutMaxOnDeath = -1.0f;
    private float ticksFadeOutCurOnDeath = 0.0f;
    protected boolean fadingOut = false;
    public float avoidTerrainAngle = 0.0f;
    private boolean slantParticleToWind = false;

    public EntityRotFX(World par1World, double par2, double par4, double par6, double par8, double par10, double par12) {
        super(par1World, par2, par4, par6, par8, par10, par12);
        this.func_187115_a(0.3f, 0.3f);
        this.entityID = par1World.field_73012_v.nextInt(100000);
    }

    public boolean isSlantParticleToWind() {
        return this.slantParticleToWind;
    }

    public void setSlantParticleToWind(boolean slantParticleToWind) {
        this.slantParticleToWind = slantParticleToWind;
    }

    public float getTicksFadeOutMaxOnDeath() {
        return this.ticksFadeOutMaxOnDeath;
    }

    public void setTicksFadeOutMaxOnDeath(float ticksFadeOutMaxOnDeath) {
        this.ticksFadeOutMaxOnDeath = ticksFadeOutMaxOnDeath;
    }

    public boolean isKillWhenUnderTopmostBlock() {
        return this.killWhenUnderTopmostBlock;
    }

    public void setKillWhenUnderTopmostBlock(boolean killWhenUnderTopmostBlock) {
        this.killWhenUnderTopmostBlock = killWhenUnderTopmostBlock;
    }

    public boolean isDontRenderUnderTopmostBlock() {
        return this.dontRenderUnderTopmostBlock;
    }

    public void setDontRenderUnderTopmostBlock(boolean dontRenderUnderTopmostBlock) {
        this.dontRenderUnderTopmostBlock = dontRenderUnderTopmostBlock;
    }

    public float getTicksFadeInMax() {
        return this.ticksFadeInMax;
    }

    public void setTicksFadeInMax(float ticksFadeInMax) {
        this.ticksFadeInMax = ticksFadeInMax;
    }

    public float getTicksFadeOutMax() {
        return this.ticksFadeOutMax;
    }

    public void setTicksFadeOutMax(float ticksFadeOutMax) {
        this.ticksFadeOutMax = ticksFadeOutMax;
    }

    public int getParticleTextureIndex() {
        return this.particleTextureIndexInt;
    }

    public void func_187114_a(int par) {
        this.field_70547_e = par;
    }

    public float getAlphaF() {
        return this.field_82339_as;
    }

    public void func_187112_i() {
        if (this.pb != null) {
            this.pb.particles.remove(this);
        }
        super.func_187112_i();
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (!this.isVanillaMotionDampen()) {
            this.field_187129_i /= (double)0.98f;
            this.field_187130_j /= (double)0.98f;
            this.field_187131_k /= (double)0.98f;
        }
        if (!this.field_187133_m && !this.fadingOut) {
            int height;
            if (this.killOnCollide && this.isCollided()) {
                this.startDeath();
            }
            if (this.killWhenUnderTopmostBlock && this.field_187127_g <= (double)(height = this.field_187122_b.func_175725_q(new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h)).func_177956_o())) {
                this.startDeath();
            }
        }
        if (!this.collisionSpeedDampen && this.field_187132_l) {
            this.field_187129_i /= (double)0.7f;
            this.field_187131_k /= (double)0.7f;
        }
        if (this.spinFast) {
            this.rotationPitch += this.entityID % 2 == 0 ? 10.0f : -10.0f;
            this.rotationYaw += this.entityID % 2 == 0 ? -10.0f : 10.0f;
        }
        if (!this.fadingOut) {
            if (this.ticksFadeInMax > 0.0f && (float)this.getAge() < this.ticksFadeInMax) {
                this.func_82338_g((float)this.getAge() / this.ticksFadeInMax);
            } else if (this.ticksFadeOutMax > 0.0f && (float)this.getAge() > (float)this.getMaxAge() - this.ticksFadeOutMax) {
                float count = (float)this.getAge() - ((float)this.getMaxAge() - this.ticksFadeOutMax);
                float val = (this.ticksFadeOutMax - count) / this.ticksFadeOutMax;
                this.func_82338_g(val);
            } else if (this.ticksFadeInMax > 0.0f || this.ticksFadeOutMax > 0.0f) {
                this.func_82338_g(1.0f);
            }
        } else {
            if (this.ticksFadeOutCurOnDeath < this.ticksFadeOutMaxOnDeath) {
                this.ticksFadeOutCurOnDeath += 1.0f;
            } else {
                this.func_187112_i();
            }
            float val = 1.0f - this.ticksFadeOutCurOnDeath / this.ticksFadeOutMaxOnDeath;
            this.func_82338_g(val);
        }
    }

    public void startDeath() {
        if (this.ticksFadeOutMaxOnDeath > 0.0f) {
            this.ticksFadeOutCurOnDeath = 0.0f;
            this.fadingOut = true;
        } else {
            this.func_187112_i();
        }
    }

    public void func_70536_a(int par1) {
        this.particleTextureIndexInt = par1;
        if (this.func_70537_b() == 0) {
            super.func_70536_a(par1);
        }
    }

    public int func_70537_b() {
        return 5;
    }

    public void spawnAsWeatherEffect() {
        this.weatherEffect = true;
        ExtendedRenderer.rotEffRenderer.addEffect(this);
    }

    public int getAge() {
        return this.field_70546_d;
    }

    public void setAge(int age) {
        this.field_70546_d = age;
    }

    public int getMaxAge() {
        return this.field_70547_e;
    }

    public void func_187115_a(float par1, float par2) {
        super.func_187115_a(par1, par2);
    }

    public void setGravity(float par) {
        this.field_70545_g = par;
    }

    public float maxRenderRange() {
        return this.renderRange;
    }

    public void setScale(float parScale) {
        this.field_70544_f = parScale;
    }

    public float getScale() {
        return this.field_70544_f;
    }

    public Vec3 getPos() {
        return new Vec3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    public double getPosX() {
        return this.field_187126_f;
    }

    public void setPosX(double posX) {
        this.field_187126_f = posX;
    }

    public double getPosY() {
        return this.field_187127_g;
    }

    public void setPosY(double posY) {
        this.field_187127_g = posY;
    }

    public double getPosZ() {
        return this.field_187128_h;
    }

    public void setPosZ(double posZ) {
        this.field_187128_h = posZ;
    }

    public double getMotionX() {
        return this.field_187129_i;
    }

    public void setMotionX(double motionX) {
        this.field_187129_i = motionX;
    }

    public double getMotionY() {
        return this.field_187130_j;
    }

    public void setMotionY(double motionY) {
        this.field_187130_j = motionY;
    }

    public double getMotionZ() {
        return this.field_187131_k;
    }

    public void setMotionZ(double motionZ) {
        this.field_187131_k = motionZ;
    }

    public double getPrevPosX() {
        return this.field_187123_c;
    }

    public void setPrevPosX(double prevPosX) {
        this.field_187123_c = prevPosX;
    }

    public double getPrevPosY() {
        return this.field_187124_d;
    }

    public void setPrevPosY(double prevPosY) {
        this.field_187124_d = prevPosY;
    }

    public double getPrevPosZ() {
        return this.field_187125_e;
    }

    public void setPrevPosZ(double prevPosZ) {
        this.field_187125_e = prevPosZ;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public World getWorld() {
        return this.field_187122_b;
    }

    public void setCanCollide(boolean val) {
        this.field_190017_n = val;
    }

    public boolean getCanCollide() {
        return this.field_190017_n;
    }

    public boolean isCollided() {
        return this.field_187132_l;
    }

    public double getDistance(double x, double y, double z) {
        double d0 = this.field_187126_f - x;
        double d1 = this.field_187127_g - y;
        double d2 = this.field_187128_h - z;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    public void func_180434_a(VertexBuffer worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!this.facePlayer) {
            rotationX = MathHelper.func_76134_b((float)(this.rotationYaw * (float)Math.PI / 180.0f));
            rotationYZ = MathHelper.func_76126_a((float)(this.rotationYaw * (float)Math.PI / 180.0f));
            rotationXY = -rotationYZ * MathHelper.func_76126_a((float)(this.rotationPitch * (float)Math.PI / 180.0f));
            rotationXZ = rotationX * MathHelper.func_76126_a((float)(this.rotationPitch * (float)Math.PI / 180.0f));
            rotationZ = MathHelper.func_76134_b((float)(this.rotationPitch * (float)Math.PI / 180.0f));
        }
        super.func_180434_a(worldRendererIn, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    @Override
    public float getWindWeight() {
        return this.windWeight;
    }

    @Override
    public int getParticleDecayExtra() {
        return this.particleDecayExtra;
    }

    public boolean func_187111_c() {
        return this.isTransparent;
    }

    public void setKillOnCollide(boolean val) {
        this.killOnCollide = val;
    }

    public void func_187110_a(double x, double y, double z) {
        double yy = y;
        double xx = x;
        double zz = z;
        if (this.field_190017_n) {
            List list = this.field_187122_b.func_184144_a((Entity)null, this.func_187116_l().func_72321_a(x, y, z));
            for (AxisAlignedBB axisalignedbb : list) {
                y = axisalignedbb.func_72323_b(this.func_187116_l(), y);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, y, 0.0));
            for (AxisAlignedBB axisalignedbb1 : list) {
                x = axisalignedbb1.func_72316_a(this.func_187116_l(), x);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(x, 0.0, 0.0));
            for (AxisAlignedBB axisalignedbb2 : list) {
                z = axisalignedbb2.func_72322_c(this.func_187116_l(), z);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, 0.0, z));
        } else {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        }
        this.func_187118_j();
        boolean bl = this.field_187132_l = yy != y || xx != x || zz != z;
        if (xx != x) {
            this.field_187129_i = 0.0;
        }
        if (zz != z) {
            this.field_187131_k = 0.0;
        }
    }

    public void setFacePlayer(boolean val) {
        this.facePlayer = val;
    }

    public TextureAtlasSprite getParticleTexture() {
        return this.field_187119_C;
    }

    public boolean isVanillaMotionDampen() {
        return this.vanillaMotionDampen;
    }

    public void setVanillaMotionDampen(boolean motionDampen) {
        this.vanillaMotionDampen = motionDampen;
    }

    public int func_189214_a(float p_189214_1_) {
        return super.func_189214_a(p_189214_1_);
    }
}

