/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.render;

import CoroUtil.config.ConfigCoroAI;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import extendedrenderer.particle.entity.EntityRotFX;
import java.nio.FloatBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEmitter;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RotatingParticleManager {
    private static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    protected World world;
    public final List<ArrayDeque<Particle>[][]> fxLayers = new ArrayList<ArrayDeque<Particle>[][]>();
    private final Queue<ParticleEmitter> particleEmitters = Queues.newArrayDeque();
    private final TextureManager renderer;
    private final Map<Integer, IParticleFactory> particleTypes = Maps.newHashMap();
    private final Queue<Particle> queueEntityFX = Queues.newArrayDeque();
    private final FloatBuffer fogColorBuffer = GLAllocation.func_74529_h((int)16);
    public static float sandstormFogAmount = 0.0f;
    public static int debugParticleRenderCount;

    public RotatingParticleManager(World worldIn, TextureManager rendererIn) {
        this.world = worldIn;
        this.renderer = rendererIn;
        this.fxLayers.add(0, new ArrayDeque[4][]);
        this.fxLayers.add(1, new ArrayDeque[4][]);
        for (ArrayDeque<Particle>[][] entry : this.fxLayers) {
            for (int i = 0; i < 4; ++i) {
                entry[i] = new ArrayDeque[2];
                for (int j = 0; j < 2; ++j) {
                    entry[i][j] = Queues.newArrayDeque();
                }
            }
        }
    }

    public void registerParticle(int id, IParticleFactory particleFactory) {
        this.particleTypes.put(id, particleFactory);
    }

    public void emitParticleAtEntity(Entity entityIn, EnumParticleTypes particleTypes) {
        this.particleEmitters.add(new ParticleEmitter(this.world, entityIn, particleTypes));
    }

    @Nullable
    public Particle spawnEffectParticle(int particleId, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        Particle particle;
        IParticleFactory iparticlefactory = this.particleTypes.get(particleId);
        if (iparticlefactory != null && (particle = iparticlefactory.func_178902_a(particleId, this.world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters)) != null) {
            this.addEffect(particle);
            return particle;
        }
        return null;
    }

    public void addEffect(Particle effect) {
        if (effect == null) {
            return;
        }
        this.queueEntityFX.add(effect);
    }

    public void updateEffects() {
        for (int i = 0; i < 4; ++i) {
            this.updateEffectLayer(i);
        }
        if (!this.particleEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (ParticleEmitter particleemitter : this.particleEmitters) {
                particleemitter.func_189213_a();
                if (particleemitter.func_187113_k()) continue;
                list.add(particleemitter);
            }
            this.particleEmitters.removeAll(list);
        }
        if (!this.queueEntityFX.isEmpty()) {
            Particle particle = this.queueEntityFX.poll();
            while (particle != null) {
                ArrayDeque<Particle>[][] entry;
                int j = particle.func_70537_b();
                int k = particle.func_187111_c() ? 0 : 1;
                int renderOrder = 0;
                if (particle instanceof EntityRotFX) {
                    renderOrder = ((EntityRotFX)particle).renderOrder;
                }
                if ((entry = this.fxLayers.get(renderOrder))[j][k].size() >= 16384) {
                    entry[j][k].removeFirst();
                }
                entry[j][k].add(particle);
                particle = this.queueEntityFX.poll();
            }
        }
    }

    private void updateEffectLayer(int layer) {
        for (int i = 0; i < 2; ++i) {
            for (ArrayDeque<Particle>[][] entry : this.fxLayers) {
                this.tickParticleList(entry[layer][i]);
            }
        }
    }

    private void tickParticleList(Queue<Particle> p_187240_1_) {
        if (!p_187240_1_.isEmpty()) {
            Iterator iterator = p_187240_1_.iterator();
            while (iterator.hasNext()) {
                Particle particle = (Particle)iterator.next();
                this.tickParticle(particle);
                if (particle.func_187113_k()) continue;
                iterator.remove();
            }
        }
    }

    private void tickParticle(final Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Rotating Particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
            final int i = particle.func_70537_b();
            crashreportcategory.func_189529_a("Rotating Particle", (ICrashReportDetail)new ICrashReportDetail<String>(){

                public String call() throws Exception {
                    return particle.toString();
                }
            });
            crashreportcategory.func_189529_a("Particle Type", (ICrashReportDetail)new ICrashReportDetail<String>(){

                public String call() throws Exception {
                    return i == 0 ? "MISC_TEXTURE" : (i == 1 ? "TERRAIN_TEXTURE" : (i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i));
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    public void renderParticles(Entity entityIn, float partialTicks) {
        boolean fog;
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        GlStateManager.func_179129_p();
        int mip_min = 0;
        int mip_mag = 0;
        if (!ConfigCoroAI.disableMipmapFix) {
            mip_min = GL11.glGetTexParameteri((int)3553, (int)10241);
            mip_mag = GL11.glGetTexParameteri((int)3553, (int)10240);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityRenderer er = mc.field_71460_t;
        boolean testGLUOverride = false;
        if (testGLUOverride) {
            // empty if block
        }
        if (fog = true) {
            boolean ATmode = true;
            if (ATmode) {
                er.func_78468_a(0, partialTicks);
                float fogScaleInvert = 1.0f - sandstormFogAmount;
                GlStateManager.func_179102_b((float)0.0f);
                GlStateManager.func_179153_c((float)Math.max(40.0f, 1000.0f * fogScaleInvert));
            } else {
                float fogColorRed = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)Minecraft.func_71410_x().field_71460_t, (String[])new String[]{"field_175080_Q"})).floatValue();
                float fogColorGreen = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)Minecraft.func_71410_x().field_71460_t, (String[])new String[]{"field_175082_R"})).floatValue();
                float fogColorBlue = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)Minecraft.func_71410_x().field_71460_t, (String[])new String[]{"field_175081_S"})).floatValue();
                GlStateManager.func_187402_b((int)2918, (FloatBuffer)this.setFogColorBuffer(fogColorRed, fogColorGreen, fogColorBlue, 1.0f));
                GlStateManager.func_187432_a((float)0.0f, (float)-1.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Entity entity = mc.func_175606_aa();
                IBlockState iblockstate = ActiveRenderInfo.func_186703_a((World)mc.field_71441_e, (Entity)entity, (float)partialTicks);
                GlStateManager.func_179095_a((float)1.0f);
                GlStateManager.func_179142_g();
                GlStateManager.func_179127_m();
                GlStateManager.func_179104_a((int)1028, (int)4608);
            }
        }
        debugParticleRenderCount = 0;
        for (ArrayDeque<Particle>[][] entry : this.fxLayers) {
            for (int i_nf = 0; i_nf < 3; ++i_nf) {
                int i = i_nf;
                for (int j = 0; j < 2; ++j) {
                    if (entry[i][j].isEmpty()) continue;
                    switch (j) {
                        case 0: {
                            GlStateManager.func_179132_a((boolean)false);
                            break;
                        }
                        case 1: {
                            GlStateManager.func_179132_a((boolean)true);
                        }
                    }
                    switch (i) {
                        default: {
                            this.renderer.func_110577_a(PARTICLE_TEXTURES);
                            break;
                        }
                        case 1: {
                            this.renderer.func_110577_a(TextureMap.field_110575_b);
                        }
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    VertexBuffer vertexbuffer = tessellator.func_178180_c();
                    vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    for (Particle particle : entry[i][j]) {
                        particle.func_180434_a(vertexbuffer, entityIn, partialTicks, f, f4, f1, f2, f3);
                        ++debugParticleRenderCount;
                    }
                    tessellator.func_78381_a();
                }
            }
        }
        if (fog) {
            GlStateManager.func_179106_n();
        }
        if (!ConfigCoroAI.disableMipmapFix) {
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)mip_min);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)mip_mag);
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public void renderLitParticles(Entity entityIn, float partialTick) {
        float f = (float)Math.PI / 180;
        float f1 = MathHelper.func_76134_b((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76126_a((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
        float f3 = -f2 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        float f4 = f1 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76134_b((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        for (ArrayDeque<Particle>[][] entry : this.fxLayers) {
            for (int i = 0; i < 2; ++i) {
                ArrayDeque<Particle> queue = entry[3][i];
                if (queue.isEmpty()) continue;
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer vertexbuffer = tessellator.func_178180_c();
                for (Particle particle : queue) {
                    particle.func_180434_a(vertexbuffer, entityIn, partialTick, f1, f5, f2, f3, f4);
                }
            }
        }
    }

    public void clearEffects(@Nullable World worldIn) {
        this.world = worldIn;
        for (ArrayDeque<Particle>[][] entry : this.fxLayers) {
            for (int i = 0; i < entry.length; ++i) {
                for (int j = 0; j < entry[i].length; ++j) {
                    if (entry[i][j] == null) continue;
                    entry[i][j].clear();
                }
            }
        }
        this.particleEmitters.clear();
    }

    public String getStatistics() {
        int count = 0;
        return "" + count;
    }

    private FloatBuffer setFogColorBuffer(float red, float green, float blue, float alpha) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(red).put(green).put(blue).put(alpha);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

