/*
 * Decompiled with CFR 0.152.
 */
package ZombieAwareness;

import ZombieAwareness.WorldEventListener;
import ZombieAwareness.ZAUtil;
import ZombieAwareness.ZombieAwareness;
import net.minecraft.util.EnumHand;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ZAEventHandler {
    public static World lastWorld = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public void soundEvent(PlaySoundAtEntityEvent event) {
        try {
            if (event.getEntity() == null) return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void setAttackTarget(LivingSetAttackTargetEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!ZAUtil.isZombieAwarenessActive(event.getEntityLiving().field_70170_p)) {
                return;
            }
            ZAUtil.hookSetAttackTarget(event);
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!ZAUtil.isZombieAwarenessActive(event.getEntityLiving().field_70170_p)) {
                return;
            }
            ZAUtil.hookBlockEvent((PlayerEvent)event, 20);
        }
    }

    @SubscribeEvent
    public void harvest(PlayerEvent.HarvestCheck event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!ZAUtil.isZombieAwarenessActive(event.getEntityLiving().field_70170_p)) {
                return;
            }
            ZombieAwareness.dbg("harvest event");
            ZAUtil.hookBlockEvent((PlayerEvent)event, 3);
        }
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || event.getHand() == EnumHand.MAIN_HAND) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void tickServer(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (!ZAUtil.isZombieAwarenessActive((World)DimensionManager.getWorld((int)0))) {
                return;
            }
            if (lastWorld != DimensionManager.getWorld((int)0)) {
                lastWorld = DimensionManager.getWorld((int)0);
                WorldServer[] worlds = DimensionManager.getWorlds();
                for (int i = 0; i < worlds.length; ++i) {
                    WorldServer world = worlds[i];
                    world.func_72954_a((IWorldEventListener)new WorldEventListener(world.field_73011_w.getDimension()));
                }
            }
            ZombieAwareness.instance.onTick(FMLCommonHandler.instance().getMinecraftServerInstance());
        }
    }
}

