/*
 * Decompiled with CFR 0.152.
 */
package ZombieAwareness;

import CoroUtil.OldUtil;
import CoroUtil.pathfinding.IPFCallback;
import CoroUtil.pathfinding.PFCallbackItem;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilEntity;
import ZombieAwareness.CommandZA;
import ZombieAwareness.CommonProxy;
import ZombieAwareness.SoundRegistry;
import ZombieAwareness.ZAEventHandler;
import ZombieAwareness.ZAUtil;
import ZombieAwareness.config.ZAConfig;
import ZombieAwareness.config.ZAConfigClient;
import ZombieAwareness.config.ZAConfigFeatures;
import ZombieAwareness.config.ZAConfigMobLists;
import ZombieAwareness.config.ZAConfigPlayerLists;
import ZombieAwareness.config.ZAConfigSpawning;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import modconfig.ConfigMod;
import modconfig.IConfigCategory;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod(modid="zombieawareness", name="Zombie Awareness", version="1.11.2-1.11.9", dependencies="required-after:coroutil", acceptedMinecraftVersions="[1.11.2]")
public class ZombieAwareness
implements IPFCallback {
    @Mod.Instance(value="zombieawareness")
    public static ZombieAwareness instance;
    public static final String modID = "zombieawareness";
    public static final String version = "1.11.2-1.11.9";
    public static MinecraftServer mc;
    public static World worldRef;
    public static boolean ingui;
    public static int lastZombieCount;
    public static int lastMobsCountSurface;
    public static int lastMobsCountCaves;
    public static long lastSpawnTime;
    public static long lastSpawnSysTime;
    @SidedProxy(clientSide="ZombieAwareness.ClientProxy", serverSide="ZombieAwareness.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration config;
    public static String configCategory;
    public static ZAConfigMobLists mobLists;
    public static HashMap<Class, String> lookupClassToOldName;
    public static HashMap<Class, String> lookupClassToRegisteredName;
    public static int timeout;
    public static String msg;
    public static int color;
    public static int defaultColor;
    public static boolean keyDownLastTick;
    public static boolean heldItemLastTick;
    public static boolean toggle;
    public ArrayList<PFCallbackItem> callbackList = new ArrayList();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ZAConfigFeatures configMain = new ZAConfigFeatures();
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)new ZAConfig());
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)configMain);
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)new ZAConfigPlayerLists());
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)new ZAConfigSpawning());
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)new ZAConfigClient());
        configMain.hookUpdatedValues();
        config = new Configuration(new File("config" + File.separator + mobLists.getConfigFileName() + ".cfg"));
        String comment = "Entities to be enhanced, will show everything ZombieAwareness should be able to enhance, only zombie based mobs and some others are default on, if a mob uses ground pathfinding and is able to be hostile you can try enabling more from other mods, but how well the enhancing works depends on how the mod implemented their mob";
        config.setCategoryComment(configCategory, comment);
        config.save();
        SoundRegistry.init();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ZAEventHandler());
        proxy.init(this);
    }

    @Mod.EventHandler
    public void loadPost(FMLPostInitializationEvent event) {
        try {
            ZombieAwareness.generateEntityTickList();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ((ServerCommandManager)FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D()).func_71560_a((ICommand)new CommandZA());
    }

    public void onTick(MinecraftServer var1) {
        this.onTickInGame(var1);
    }

    public void onTickInGame(MinecraftServer var1) {
        mc = var1;
        World worldTemp = worldRef;
        if (worldTemp != null) {
            worldTemp = mc.func_71218_a(0);
            if (worldTemp != null) {
                this.worldTick(worldTemp);
            }
        } else {
            worldRef = mc.func_71218_a(0);
        }
        ingui = false;
    }

    public void worldTick(World world) {
        if (!world.field_72995_K) {
            this.manageCallbackQueue();
            int lastCountZombies = 0;
            int lastCountMobsSurface = 0;
            int lastCountMobsCaves = 0;
            boolean spawned = false;
            Random rand = new Random();
            if (lastSpawnTime - 1000L > world.func_82737_E()) {
                lastSpawnTime = 0L;
            }
            if (world.func_82737_E() % (long)ZAConfig.tickRateAILoop == 0L) {
                List ents = world.field_72996_f;
                for (int i = 0; i < world.field_72996_f.size(); ++i) {
                    IBlockState state;
                    EntityPlayer closestPlayer;
                    Entity ent = (Entity)world.field_72996_f.get(i);
                    if (!ZombieAwareness.canProcessEntity(ent) || !(ent instanceof EntityLiving)) continue;
                    ZAUtil.tickAI((EntityLiving)ent);
                    if (((EntityLiving)ent).func_70661_as().func_75500_f() || !ent.field_70122_E || ent.field_70123_F) {
                        // empty if block
                    }
                    if (world.field_73011_w.getDimension() != 0 || !(ent instanceof IMob)) continue;
                    int x = MathHelper.func_76128_c((double)ent.field_70165_t);
                    int y = MathHelper.func_76128_c((double)ent.field_70163_u);
                    int z = MathHelper.func_76128_c((double)ent.field_70161_v);
                    if (ZAUtil.isInDarkCave(world, x, (int)(ent.func_174813_aQ().field_72338_b - 0.3), z, false)) {
                        ++lastCountMobsCaves;
                    } else {
                        ++lastCountMobsSurface;
                    }
                    if (!(ent instanceof EntityZombie)) continue;
                    ++lastCountZombies;
                    if (lastSpawnTime >= ent.field_70170_p.func_82737_E() || spawned || ent.field_70170_p.func_72890_a(ent, 32.0) != null || rand.nextInt(ZAConfigSpawning.maxZombiesNightBaseRarity + lastZombieCount * 4 / Math.max(1, ZAConfig.tickRateAILoop)) != 0) continue;
                    if (!ent.field_70170_p.func_72935_r() && lastZombieCount < ZAConfigSpawning.maxZombiesNight && ent.field_70170_p.func_175678_i(new BlockPos(x, y, z)) && ent.field_70170_p.func_175671_l(new BlockPos(x, y, z)) < 5) {
                        EntityZombie entZ = new EntityZombie(ent.field_70170_p);
                        entZ.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                        entZ.func_180482_a(world.func_175649_E(new BlockPos((Entity)entZ)), (IEntityLivingData)null);
                        ZAUtil.giveRandomSpeedBoost((EntityLiving)entZ);
                        ent.field_70170_p.func_72838_d((Entity)entZ);
                        spawned = true;
                        lastSpawnTime = (long)ZAConfigSpawning.zombieSpawnTickDelay + ent.field_70170_p.func_82737_E();
                        lastSpawnSysTime = System.currentTimeMillis();
                        if (!ZAConfig.debugConsoleSpawns) continue;
                        ZombieAwareness.dbg("Spawned new surface zombie at: " + ent.field_70165_t + ", " + ent.field_70163_u + ", " + ent.field_70161_v);
                        continue;
                    }
                    if (!ZAConfigFeatures.extraSpawningCave || lastZombieCount >= ZAConfigSpawning.maxZombiesNight || (closestPlayer = ent.field_70170_p.func_184142_a(ent, (double)ZAConfigSpawning.extraSpawningDistMax, (double)ZAConfigSpawning.extraSpawningDistMax)) == null || ZAConfigPlayerLists.whiteListUsedExtraSpawning && !ZAConfigPlayerLists.whitelistExtraSpawning.contains(CoroUtilEntity.getName((Entity)closestPlayer)) || !(closestPlayer.func_70068_e(ent) > (double)ZAConfigSpawning.extraSpawningDistMin) || ent.field_70170_p.func_175678_i(new BlockPos(x, y, z)) || ent.field_70170_p.func_175671_l(new BlockPos(x, y, z)) >= 5 || CoroUtilBlock.isAir((Block)(state = ent.field_70170_p.func_180495_p(new BlockPos(x, (int)(ent.func_174813_aQ().field_72338_b - 0.5), z))).func_177230_c()) || state.func_177230_c() == Blocks.field_150349_c && state.func_185904_a() != Material.field_151577_b) continue;
                    EntityZombie entZ = new EntityZombie(ent.field_70170_p);
                    entZ.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                    entZ.func_180482_a(world.func_175649_E(new BlockPos((Entity)entZ)), (IEntityLivingData)null);
                    ZAUtil.giveRandomSpeedBoost((EntityLiving)entZ);
                    ent.field_70170_p.func_72838_d((Entity)entZ);
                    if (ZAConfigSpawning.extraSpawningAutoTarget) {
                        entZ.func_70624_b((EntityLivingBase)closestPlayer);
                    }
                    spawned = true;
                    lastSpawnTime = (long)ZAConfigSpawning.zombieSpawnTickDelay + ent.field_70170_p.func_82737_E();
                    lastSpawnSysTime = System.currentTimeMillis();
                    if (!ZAConfig.debugConsoleSpawns) continue;
                    ZombieAwareness.dbg("Spawned new cave zombie at: " + ent.field_70165_t + ", " + ent.field_70163_u + ", " + ent.field_70161_v);
                }
                if (world.field_73011_w.getDimension() == 0) {
                    lastZombieCount = lastCountZombies;
                    lastMobsCountSurface = lastCountMobsSurface;
                    lastMobsCountCaves = lastCountMobsCaves;
                }
            }
        }
        if (world.func_82737_E() % (long)ZAConfig.tickRatePlayerLoop == 0L) {
            for (int i = 0; i < world.field_73010_i.size(); ++i) {
                EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
                if (player == null) continue;
                ZAUtil.tickPlayer(player);
            }
        }
        ZAUtil.tickWorld(world);
    }

    public static void displayMessage(String var0, int var1) {
        msg = var0;
        timeout = 85;
        color = var1;
    }

    public static void displayMessage(String var0) {
        ZombieAwareness.displayMessage(var0, defaultColor);
    }

    public synchronized void pfComplete(PFCallbackItem ci) {
        this.callbackList.add(ci);
    }

    public void manageCallbackQueue() {
        ArrayList<PFCallbackItem> list = this.getQueue();
        try {
            for (int i = 0; i < list.size(); ++i) {
                PFCallbackItem item = list.get(i);
                if (item.ent.field_70128_L || !OldUtil.chunkExists((World)item.ent.field_70170_p, (int)MathHelper.func_76128_c((double)(item.ent.field_70165_t / 16.0)), (int)MathHelper.func_76128_c((double)(item.ent.field_70161_v / 16.0)))) continue;
                item.ent.func_70661_as().func_75484_a(item.pe, (double)item.speed);
            }
        }
        catch (Exception ex) {
            System.out.println("Crash in ZA Callback Item manager");
            ex.printStackTrace();
        }
        list.clear();
    }

    public ArrayList<PFCallbackItem> getQueue() {
        return this.callbackList;
    }

    public static boolean canProcessEntity(Entity ent) {
        if (!ZombieAwareness.canEntityBeProcessedOverride(ent)) {
            return false;
        }
        return ZombieAwareness.canProcessEntity(ent.getClass(), false);
    }

    public static boolean canProcessEntity(Class ent, boolean pregen) {
        String entName = ZombieAwareness.getEntityRegisteredName(ent);
        if (ZAUtil.lookupTickableEntities.containsKey(ent)) {
            return ZAUtil.lookupTickableEntities.get(ent);
        }
        boolean result = false;
        if (ZombieAwareness.canConfigEntity(ent)) {
            if (!pregen) {
                config.load();
            }
            boolean canProcess = ZombieAwareness.getDefaultForEntity(ent);
            result = config.get(configCategory, entName, canProcess).getBoolean(canProcess);
            if (!pregen) {
                config.save();
            }
            ZAUtil.lookupTickableEntities.put(ent, result);
        }
        return result;
    }

    public static boolean canEntityBeProcessedOverride(Entity entity) {
        return true;
    }

    public static boolean canConfigEntity(Class ent) {
        return EntityMob.class.isAssignableFrom(ent) || IMob.class.isAssignableFrom(ent);
    }

    public static boolean getDefaultForEntity(Class ent) {
        boolean result = false;
        if (ZombieAwareness.canConfigEntity(ent)) {
            result = ent.isAssignableFrom(EntityZombie.class) || ent.isAssignableFrom(EntitySkeleton.class) || ent.isAssignableFrom(EntityWitch.class) || ent.isAssignableFrom(EntitySpider.class);
        }
        return result;
    }

    public static void generateEntityTickList() {
        config.load();
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            lookupClassToOldName.put(((EntityEntry)entry.getValue()).getEntityClass(), ((EntityEntry)entry.getValue()).getName());
            lookupClassToRegisteredName.put(((EntityEntry)entry.getValue()).getEntityClass(), ((ResourceLocation)entry.getKey()).toString());
            boolean bl = ZombieAwareness.canProcessEntity(((EntityEntry)entry.getValue()).getEntityClass(), true);
        }
        config.save();
    }

    public static void dbg(Object obj) {
        if (ZAConfig.debugConsole) {
            System.out.println(obj);
        }
    }

    public static String getEntityRegisteredName(Class ent) {
        try {
            return ZombieAwareness.getClassToOldName(ent);
        }
        catch (Exception ex) {
            if (ZAConfig.debugConsole) {
                ex.printStackTrace();
            }
            return ent.getClass().getSimpleName();
        }
    }

    public static String getClassToOldName(Class ent) {
        return lookupClassToOldName.get(ent);
    }

    static {
        configCategory = "tickable_entities";
        mobLists = new ZAConfigMobLists();
        lookupClassToOldName = new HashMap();
        lookupClassToRegisteredName = new HashMap();
        defaultColor = 0xFFFFFF;
        keyDownLastTick = false;
        heldItemLastTick = false;
        toggle = false;
    }
}

