/*
 * Decompiled with CFR 0.152.
 */
package rtk;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import rtk.block.BlockBase;
import rtk.block.BlockDiversEnderTent;
import rtk.block.BlockDiversTent;
import rtk.block.BlockEmergencyTent;
import rtk.block.BlockEnderTent;
import rtk.block.BlockFourierTransformer;
import rtk.block.BlockHole;
import rtk.block.BlockLevitator;
import rtk.block.BlockTentBreakable;
import rtk.block.BlockTentWall;

public class ModBlocks {
    public static BlockBase emergencyTent;
    public static BlockBase tent;
    public static BlockBase diversTent;
    public static BlockBase enderTent;
    public static BlockBase diversEnderTent;
    public static BlockBase levitator;
    public static BlockBase ultraDispenser;
    public static BlockBase hole;
    public static BlockBase fourierTransformer;
    public static BlockTentWall tentWall;
    static HashSet<Class<? extends TileEntity>> registeredTEs;

    public static void init() {
        emergencyTent = ModBlocks.register(new BlockEmergencyTent("emergencyTent"));
        tent = ModBlocks.register(new BlockTentBreakable("tent"));
        diversTent = ModBlocks.register(new BlockDiversTent("diversTent"));
        enderTent = ModBlocks.register(new BlockEnderTent("enderTent"));
        diversEnderTent = ModBlocks.register(new BlockDiversEnderTent("diversEnderTent"));
        tentWall = ModBlocks.register(new BlockTentWall("tentWall"));
        levitator = ModBlocks.register(new BlockLevitator("levitator"));
        hole = ModBlocks.register(new BlockHole("hole"));
        fourierTransformer = ModBlocks.register(new BlockFourierTransformer("fourierTransformer"));
    }

    private static <T extends Block> T register(T block, ItemBlock itemBlock) {
        GameRegistry.register(block);
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        if (block instanceof BlockBase) {
            BlockBase b = (BlockBase)block;
            b.init(itemBlock);
            if (b.func_149716_u() && !registeredTEs.contains(b.getTileEntityClass())) {
                registeredTEs.add(b.getTileEntityClass());
                GameRegistry.registerTileEntity(b.getTileEntityClass(), (String)b.func_149739_a());
                System.out.println("Registered tile entity: " + b.func_149739_a());
            }
        }
        return block;
    }

    private static <T extends Block> T register(T block) {
        ItemBlock itemBlock = block instanceof BlockBase ? ((BlockBase)block).createItemBlock(block) : new ItemBlock(block);
        itemBlock.setRegistryName(block.getRegistryName());
        return ModBlocks.register(block, itemBlock);
    }

    static {
        registeredTEs = new HashSet();
    }
}

