/*
 * Decompiled with CFR 0.152.
 */
package rtk.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rtk.ModBlocks;
import rtk.block.BlockTent;
import rtk.common.CNBT;
import rtk.common.CWorld;
import rtk.tileentity.TileEnderTent;

public class BlockEnderTent
extends BlockTent {
    public BlockEnderTent(String name) {
        super(name);
    }

    @Override
    public int fuelCost() {
        return 16;
    }

    @Override
    public Item fuelType() {
        return Items.field_151079_bi;
    }

    @Override
    public IBlockState wall() {
        return ModBlocks.tentWall.variant(3);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEnderTent();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return TileEnderTent.class;
    }

    public TileEnderTent getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TileEnderTent)world.func_175625_s(pos);
    }

    @Override
    public boolean tryBuildTent(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        TileEnderTent te = this.getTileEntity((IBlockAccess)world, pos);
        boolean result = false;
        if (te.neverDeployed()) {
            result = super.tryBuildTent(world, pos, player, side);
        } else if (!te.isDeployed() && this.canBuildTent(world, pos, player)) {
            this.spendFuel(player);
            this.placeContents(world, pos);
            result = true;
        }
        if (result) {
            te.setDeployed(true);
            te.setNeverDeployed(false);
            world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
        return result;
    }

    @Override
    public void decorate(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
    }

    public void placeContents(World world, BlockPos pos) {
        BlockPos[] tentCube;
        TileEnderTent te = this.getTileEntity((IBlockAccess)world, pos);
        if (te.neverDeployed()) {
            return;
        }
        for (BlockPos otherPos : tentCube = this.tentCuboid(pos)) {
            if (pos.equals((Object)otherPos)) continue;
            TileEntity otherTileEntity = world.func_175625_s(otherPos);
            if (otherTileEntity instanceof TileEnderTent) {
                ((TileEnderTent)otherTileEntity).dontGrab = true;
            }
            world.func_180501_a(otherPos, Blocks.field_150346_d.func_176223_P(), 2);
        }
        NBTTagList blockList = te.getBlockList();
        int bsInd = 0;
        for (BlockPos otherPos : tentCube) {
            if (!pos.equals((Object)otherPos)) {
                CNBT.placeBlockFromNBT(world, otherPos, blockList.func_150305_b(bsInd));
            }
            ++bsInd;
        }
        for (BlockPos otherPos : tentCube) {
            world.func_175685_c(otherPos, world.func_180495_p(otherPos).func_177230_c());
        }
    }

    public boolean tryGrabContents(World world, BlockPos pos) {
        TileEnderTent te = this.getTileEntity((IBlockAccess)world, pos);
        if (!te.isDeployed()) {
            return false;
        }
        BlockPos[] tentCube = this.tentCuboid(pos);
        NBTTagList blockList = new NBTTagList();
        for (BlockPos otherPos : tentCube) {
            blockList.func_74742_a((NBTBase)CNBT.NBTFromBlock(world, otherPos));
        }
        for (BlockPos otherPos : tentCube) {
            if (pos.equals((Object)otherPos)) continue;
            TileEntity otherTileEntity = world.func_175625_s(otherPos);
            if (otherTileEntity instanceof TileEnderTent) {
                ((TileEnderTent)otherTileEntity).dontGrab = true;
            }
            CWorld.safeReplaceBlock(world, otherPos, Blocks.field_150346_d.func_176223_P(), 2);
        }
        for (BlockPos otherPos : tentCube) {
            if (pos.equals((Object)otherPos)) continue;
            world.func_180501_a(otherPos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.5f, 1.0f);
        te.setBlockList(blockList);
        te.setDeployed(false);
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EntityPlayer player;
        if (stack.func_77942_o()) {
            this.getTileEntity((IBlockAccess)world, pos).readTent(stack.func_77978_p());
        }
        if ((player = (EntityPlayer)placer) != null && player.field_71075_bZ.field_75098_d && stack.field_77994_a == 1) {
            player.field_71071_by.func_184437_d(stack);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        TileEnderTent te = this.getTileEntity((IBlockAccess)world, pos);
        if (te.dontGrab) {
            return;
        }
        ItemStack drop = this.tentDrop();
        this.tryGrabContents(world, pos);
        if (!te.isDeployed() && !te.neverDeployed()) {
            drop.func_77966_a(Enchantments.field_185312_x, 1);
        }
        this.getTileEntity((IBlockAccess)world, pos).writeTent(CNBT.ensureCompound(drop));
        EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), drop);
        world.func_72838_d((Entity)item);
    }

    public ItemStack tentDrop() {
        return new ItemStack((Block)ModBlocks.enderTent, 1);
    }
}

