/*
 * Decompiled with CFR 0.152.
 */
package rtk.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import rtk.RTK;
import rtk.block.BlockBaseDirectional;
import rtk.common.CMath;

public class BlockFourierTransformer
extends BlockBaseDirectional {
    public static final PropertyBool TRIGGERED = PropertyBool.func_177716_a((String)"triggered");

    public BlockFourierTransformer(String name) {
        super(Material.field_151592_s, name);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    public void init(ItemBlock item) {
        super.init(item);
        RTK.proxy.ignoreProperty(this, (IProperty)TRIGGERED);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack stack) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)TRIGGERED)).booleanValue() && world.func_175640_z(pos)) {
            this.moveEntities(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        }
        world.func_175656_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(world.func_175640_z(pos))));
    }

    public void moveEntities(World world, BlockPos pos, EnumFacing facing) {
        List entities = world.func_72872_a(Entity.class, new AxisAlignedBB(pos.func_177972_a(facing), pos.func_177972_a(facing).func_177968_d().func_177974_f().func_177984_a()));
        if (entities.isEmpty()) {
            return;
        }
        BlockPos exit = this.findExit(world, pos);
        if (exit == null) {
            return;
        }
        IBlockState otherTransformer = world.func_180495_p(exit);
        EnumFacing dir = (EnumFacing)otherTransformer.func_177229_b((IProperty)FACING);
        Vec3d destination = new Vec3d((Vec3i)exit).func_72441_c(0.5, 0.5, 0.5).func_72441_c((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
        for (Entity e : entities) {
            if (e instanceof EntityPlayerMP) {
                ((EntityPlayerMP)e).field_71135_a.func_147364_a(destination.field_72450_a, destination.field_72448_b, destination.field_72449_c, e.field_70177_z, e.field_70125_A);
                continue;
            }
            e.func_70012_b(destination.field_72450_a, destination.field_72448_b, destination.field_72449_c, e.field_70177_z, e.field_70125_A);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.5f, 1.0f);
        world.func_184148_a(null, destination.field_72450_a, destination.field_72448_b, destination.field_72449_c, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.5f, 1.0f);
    }

    public BlockPos findExit(World world, BlockPos pos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayList<BlockPos> currentDepth = new ArrayList<BlockPos>();
        ArrayList<BlockPos> nextDepth = new ArrayList<BlockPos>();
        currentDepth.add(pos);
        while (!currentDepth.isEmpty()) {
            for (BlockPos node : currentDepth) {
                visited.add(node);
                for (BlockPos neighbor : CMath.cuboid(node.func_177982_a(-1, -1, -1), node.func_177982_a(1, 1, 1))) {
                    if (!this.isConnected(world, node, neighbor) || visited.contains(neighbor)) continue;
                    if (this.isExit(world, neighbor)) {
                        return neighbor;
                    }
                    if (!this.isWire(world, neighbor)) continue;
                    nextDepth.add(neighbor);
                }
            }
            ArrayList<BlockPos> temp = currentDepth;
            currentDepth = nextDepth;
            nextDepth = temp;
            nextDepth.clear();
        }
        return null;
    }

    public boolean isExit(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockFourierTransformer && world.func_175640_z(pos);
    }

    public boolean isWire(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockRedstoneWire;
    }

    public boolean isBlockedDiagonal(World world, BlockPos from, BlockPos to) {
        BlockPos mixX = new BlockPos(to.func_177958_n(), from.func_177956_o(), from.func_177952_p());
        BlockPos mixY = new BlockPos(from.func_177958_n(), to.func_177956_o(), from.func_177952_p());
        BlockPos mixZ = new BlockPos(from.func_177958_n(), from.func_177956_o(), to.func_177952_p());
        return !world.func_175623_d(mixX) && !world.func_175623_d(mixY) && !world.func_175623_d(mixZ);
    }

    public boolean isConnected(World world, BlockPos from, BlockPos to) {
        BlockPos diff = from.func_177973_b((Vec3i)to);
        if (diff.func_177958_n() * diff.func_177952_p() != 0) {
            return false;
        }
        return diff.func_177956_o() == 0 || !this.isBlockedDiagonal(world, from, to);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TRIGGERED});
    }
}

