/*
 * Decompiled with CFR 0.152.
 */
package rtk.block;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rtk.block.BlockBaseDirectional;
import rtk.tileentity.TileLevitator;

public class BlockLevitator
extends BlockBaseDirectional {
    public static final AxisAlignedBB DOWN_BOX = BlockLevitator.boundingBoxForDir(EnumFacing.DOWN);
    public static final AxisAlignedBB UP_BOX = BlockLevitator.boundingBoxForDir(EnumFacing.UP);
    public static final AxisAlignedBB NORTH_BOX = BlockLevitator.boundingBoxForDir(EnumFacing.NORTH);
    public static final AxisAlignedBB SOUTH_BOX = BlockLevitator.boundingBoxForDir(EnumFacing.SOUTH);
    public static final AxisAlignedBB WEST_BOX = BlockLevitator.boundingBoxForDir(EnumFacing.WEST);
    public static final AxisAlignedBB EAST_BOX = BlockLevitator.boundingBoxForDir(EnumFacing.EAST);

    public BlockLevitator(String name) {
        super(Material.field_151592_s, name);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149675_a(true);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileLevitator();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return TileLevitator.class;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.func_185496_a(blockState, (IBlockAccess)worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (dir) {
            case DOWN: {
                return DOWN_BOX;
            }
            case UP: {
                return UP_BOX;
            }
            case NORTH: {
                return NORTH_BOX;
            }
            case SOUTH: {
                return SOUTH_BOX;
            }
            case WEST: {
                return WEST_BOX;
            }
            case EAST: {
                return EAST_BOX;
            }
        }
        return UP_BOX;
    }

    public static AxisAlignedBB boundingBoxForDir(EnumFacing dir) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double x2 = 1.0;
        double y2 = 1.0;
        double z2 = 1.0;
        switch (dir) {
            case DOWN: {
                y += 0.5;
                break;
            }
            case UP: {
                y2 -= 0.5;
                break;
            }
            case NORTH: {
                z += 0.5;
                break;
            }
            case SOUTH: {
                z2 -= 0.5;
                break;
            }
            case WEST: {
                x += 0.5;
                break;
            }
            case EAST: {
                x2 -= 0.5;
            }
        }
        return new AxisAlignedBB(x, y, z, x2, y2, z2);
    }
}

