/*
 * Decompiled with CFR 0.152.
 */
package rtk.block;

import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import rtk.ModBlocks;
import rtk.block.BlockBase;
import rtk.common.CMath;
import rtk.common.CWorld;

public class BlockTent
extends BlockBase {
    public BlockTent(String name) {
        super(Material.field_151580_n, name);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.5f);
        this.func_149752_b(0.5f);
    }

    public IBlockState wall() {
        return ModBlocks.tentWall.variant(1);
    }

    public int width() {
        return 9;
    }

    public boolean worksInWater() {
        return false;
    }

    public int fuelCost() {
        return 8;
    }

    public Item fuelType() {
        return Items.field_151044_h;
    }

    public boolean hasFuel(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        InventoryPlayer inv = player.field_71071_by;
        ItemStack cur = inv.func_70448_g();
        return cur != null && cur.func_77973_b() == this.fuelType() && cur.field_77994_a >= this.fuelCost();
    }

    public void spendFuel(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        InventoryPlayer inv = player.field_71071_by;
        ItemStack cur = inv.func_70448_g();
        if (cur.func_77973_b() == this.fuelType() && cur.field_77994_a >= this.fuelCost()) {
            inv.func_70298_a(inv.field_70461_c, this.fuelCost());
        }
    }

    public boolean hasRoom(World world, BlockPos pos) {
        for (BlockPos otherPos : this.tentCuboid(pos)) {
            IBlockState bs = world.func_180495_p(otherPos);
            if (bs.func_177230_c().getClass().equals(((Object)((Object)this)).getClass())) continue;
            if (!CWorld.shouldReplace(world, otherPos)) {
                return false;
            }
            if (this.worksInWater() || bs.func_177230_c() != Blocks.field_150355_j && bs.func_177230_c() != Blocks.field_150358_i) continue;
            return false;
        }
        return true;
    }

    public boolean canBuildTent(World world, BlockPos pos, EntityPlayer player) {
        if (!this.hasRoom(world, pos)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.baseTent.blocked", new Object[0]));
            return false;
        }
        if (!this.hasFuel(player)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.baseTent.insufficientFuel", new Object[0]));
            return false;
        }
        return true;
    }

    public boolean tryBuildTent(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        if (!this.canBuildTent(world, pos, player)) {
            return false;
        }
        this.spendFuel(player);
        int h = this.width() - 1;
        int r = h / 2;
        this.fillCuboid(world, pos.func_177982_a(-r, h, -r), pos.func_177982_a(r, h, r), this.wall());
        this.fillCuboid(world, pos.func_177982_a(-r, 0, -r), pos.func_177982_a(r, 0, r), this.wall());
        this.fillCuboid(world, pos.func_177982_a(r, 0, -r), pos.func_177982_a(r, h, r), this.wall());
        this.fillCuboid(world, pos.func_177982_a(-r, 0, -r), pos.func_177982_a(-r, h, r), this.wall());
        this.fillCuboid(world, pos.func_177982_a(-r, 0, r), pos.func_177982_a(r, h, r), this.wall());
        this.fillCuboid(world, pos.func_177982_a(-r, 0, -r), pos.func_177982_a(r, h, -r), this.wall());
        this.fillCuboid(world, pos.func_177982_a(1 - r, 1, 1 - r), pos.func_177982_a(r - 1, h - 1, r - 1), Blocks.field_150350_a.func_176223_P());
        this.decorate(world, pos, player, side);
        return true;
    }

    public void decorate(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        world.func_72876_a((Entity)player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, false);
    }

    public void fillCuboid(World world, BlockPos a, BlockPos b, IBlockState bs) {
        for (BlockPos pos : CMath.cuboid(a, b)) {
            if (world.func_180495_p(pos).func_177230_c().getClass().equals(((Object)((Object)this)).getClass())) continue;
            world.func_180501_a(pos, bs, 3);
        }
    }

    public BlockPos[] tentCuboid(BlockPos pos) {
        int h = this.width() - 1;
        int r = h / 2;
        return CMath.cuboid(pos.func_177982_a(-r, 0, -r), pos.func_177982_a(r, h, r));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            return this.tryBuildTent(world, pos, player, side);
        }
        return true;
    }
}

