/*
 * Decompiled with CFR 0.152.
 */
package rtk.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import rtk.RTK;
import rtk.block.BlockBase;
import rtk.common.CMath;
import rtk.item.ItemBlockVariants;

public class BlockTentWall
extends BlockBase {
    public static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)5);

    public BlockTentWall(String name) {
        super(Material.field_151580_n, name);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.2f);
        this.func_149752_b(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)));
    }

    public static boolean isTentWall(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockTentWall;
    }

    public static void tryPop(World world, BlockPos pos) {
        if (BlockTentWall.isTentWall(world, pos)) {
            world.func_175698_g(pos);
            if (!world.field_72995_K && CMath.random.nextInt(32) == 0) {
                world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, false);
            }
            for (BlockPos otherPos : CMath.cuboid(pos.func_177982_a(-1, -1, -1), pos.func_177982_a(1, 1, 1))) {
                BlockTentWall.tryPop(world, otherPos);
            }
        }
    }

    @Override
    public void init(ItemBlock item) {
        for (Integer i : VARIANT.func_177700_c()) {
            RTK.proxy.registerItemRenderer((Item)item, i, this.name + "_" + i.toString());
        }
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public ItemBlock createItemBlock(Block block) {
        return new ItemBlockVariants(block);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (Integer i : VARIANT.func_177700_c()) {
            list.add(new ItemStack(itemIn, 1, i.intValue()));
        }
    }

    public IBlockState variant(int i) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(i));
    }

    public int func_149750_m(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT) == 4 ? 15 : 0;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }
}

