/*
 * Decompiled with CFR 0.152.
 */
package rtk.entity;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import rtk.common.CMath;

public class EntitySkeletonPriest
extends EntityMob {
    private static final Predicate<Entity> NOT_UNDEAD = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_apply_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD;
        }
    };
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    int summonCooldown = 0;
    int individualSummonCoolDown = 0;

    public EntitySkeletonPriest(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 2.4f);
        this.field_70728_aV = 50;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByPlayerTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.225);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(80.0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    public boolean func_70652_k(Entity target) {
        boolean hit = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(14 + this.field_70146_Z.nextInt(30)));
        if (hit) {
            if (target instanceof EntityLivingBase) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 400));
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 400));
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 400));
            }
            Vec3d dir = target.func_174791_d().func_178788_d(this.func_174791_d()).func_72432_b().func_72441_c(0.0, 0.5, 0.0);
            target.func_70024_g(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        }
        return hit;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                EntitySkeleton mob = new EntitySkeleton(this.field_70170_p);
                mob.func_189768_a(SkeletonType.WITHER);
                mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u));
                mob.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                BlockPos pos = this.pickSpawnPoint();
                mob.func_70012_b(0.5 + (double)pos.func_177958_n(), (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), CMath.random.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)mob);
            }
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        List mobs = this.field_70170_p.func_72872_a(EntitySkeleton.class, this.func_174813_aQ().func_72314_b(30.0, 10.0, 30.0));
        for (EntitySkeleton mob : mobs) {
            mob.func_70690_d(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE));
            mob.func_70690_d(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE));
            this.addFollowAIIfAbsent((EntityLiving)mob);
            mob.func_70624_b(this.func_70638_az());
            mob.func_130011_c((Entity)this.func_110144_aD());
        }
        --this.summonCooldown;
        --this.individualSummonCoolDown;
        if (mobs.size() >= 14) {
            this.summonCooldown = 1200;
        }
        if (this.summonCooldown > 0 || this.individualSummonCoolDown > 0) {
            return;
        }
        EntitySkeleton mob = new EntitySkeleton(this.field_70170_p);
        mob.func_189768_a(SkeletonType.NORMAL);
        mob.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
        BlockPos pos = this.pickSpawnPoint();
        mob.func_70012_b(0.5 + (double)pos.func_177958_n(), (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), CMath.random.nextFloat() * 360.0f, 0.0f);
        this.field_70170_p.func_72838_d((Entity)mob);
        this.individualSummonCoolDown = 20;
    }

    public BlockPos pickSpawnPoint() {
        for (int i = 0; i < 60; ++i) {
            BlockPos pos = new BlockPos(CMath.randomVector(5.0).func_178787_e(this.func_174791_d()));
            for (int j = 0; j < 10; ++j) {
                if (this.field_70170_p.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && this.field_70170_p.func_175623_d(pos) && this.field_70170_p.func_175623_d(pos.func_177984_a())) {
                    return pos;
                }
                pos = pos.func_177984_a();
            }
        }
        return null;
    }

    public void addFollowAIIfAbsent(EntityLiving entity) {
        boolean absent = true;
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a) {
            if (!(entry.field_75733_a instanceof EntityAIFollowPriest)) continue;
            absent = false;
        }
        if (absent) {
            entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowPriest(entity, (EntityLiving)this));
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70623_bb() {
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    class EntityAIFollowPriest
    extends EntityAIBase {
        EntityLiving theEntity;
        EntityLiving priest;
        int maxDist;
        int pathingCooldown = 0;

        public EntityAIFollowPriest(EntityLiving theEntity, EntityLiving priest) {
            this.func_75248_a(3);
            this.theEntity = theEntity;
            this.priest = priest;
            this.maxDist = 10;
        }

        public void func_75246_d() {
            if (this.pathingCooldown-- > 0) {
                return;
            }
            this.pathingCooldown = 10;
            this.theEntity.func_70661_as().func_75497_a((Entity)this.priest, 1.0);
        }

        public boolean func_75250_a() {
            return this.theEntity.func_70068_e((Entity)this.priest) > (double)(this.maxDist * this.maxDist);
        }

        public void func_75251_c() {
            this.theEntity.func_70661_as().func_75499_g();
        }
    }

    class EntityAIHurtByPlayerTarget
    extends EntityAIHurtByTarget {
        public EntityAIHurtByPlayerTarget(EntityCreature creatureIn, boolean entityCallsForHelpIn, Class<?>[] targetClassesIn) {
            super(creatureIn, entityCallsForHelpIn, (Class[])targetClassesIn);
        }

        protected boolean func_75296_a(EntityLivingBase target, boolean includeInvincibles) {
            return target instanceof EntityPlayer && super.func_75296_a(target, includeInvincibles);
        }
    }
}

