/*
 * Decompiled with CFR 0.152.
 */
package rtk.inventory;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import rtk.common.CNBT;

public abstract class InventoryStack
implements IInventory {
    public ItemStack stack;
    public int stackIndex;
    ItemStack[] inventory;

    public InventoryStack(ItemStack stack, int stackIndex) {
        this.stack = stack;
        this.stackIndex = stackIndex;
        CNBT.ensureCompound(stack);
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.loadAll();
    }

    public InventoryStack(ItemStack stack) {
        this(stack, -1);
    }

    public void loadAll() {
        if (!this.getNBT().func_74764_b("inventory")) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                list.func_74742_a((NBTBase)new NBTTagCompound());
            }
            this.getNBT().func_74782_a("inventory", (NBTBase)list);
        }
        for (int i = 0; i < this.inventory.length; ++i) {
            this.loadAt(i);
        }
    }

    public void saveAll() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.saveAt(i);
        }
    }

    public void loadAt(int index) {
        this.inventory[index] = ItemStack.func_77949_a((NBTTagCompound)this.getNBTAt(index));
    }

    public void saveAt(int index) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.inventory[index] != null) {
            this.inventory[index].func_77955_b(nbt);
        }
        this.getInventoryList().func_150304_a(index, (NBTBase)nbt);
    }

    public void onChange() {
    }

    public void func_70296_d() {
        this.saveAll();
        this.onChange();
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        this.loadAt(index);
        return this.inventory[index];
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        this.loadAt(index);
        ItemStack result = ItemStackHelper.func_188382_a((ItemStack[])this.inventory, (int)index, (int)count);
        this.saveAt(index);
        this.onChange();
        return result;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        this.loadAt(index);
        ItemStack result = ItemStackHelper.func_188383_a((ItemStack[])this.inventory, (int)index);
        this.saveAt(index);
        this.onChange();
        return result;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.inventory[index] = stack;
        this.saveAt(index);
        this.onChange();
    }

    public void func_174888_l() {
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.saveAll();
        this.onChange();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_184614_ca() == this.stack || player.func_184592_cb() == this.stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    protected NBTTagCompound getNBT() {
        return this.stack.func_77978_p();
    }

    protected NBTTagCompound getNBTAt(int i) {
        return this.getInventoryList().func_150305_b(i);
    }

    protected NBTTagList getInventoryList() {
        return this.getNBT().func_150295_c("inventory", 10);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

