/*
 * Decompiled with CFR 0.152.
 */
package rtk.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import rtk.ModBlocks;
import rtk.ModItems;
import rtk.block.BlockHole;
import rtk.common.CMath;
import rtk.common.CNBT;
import rtk.common.Common;
import rtk.item.ItemBase;
import rtk.tileentity.TileHole;

public class ItemEarthStrider
extends ItemBase {
    public ItemEarthStrider(String name) {
        super(name);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
        this.func_77656_e(10000);
    }

    public NBTTagCompound ensureTag(ItemStack stack) {
        NBTTagCompound nbt = CNBT.ensureCompound(stack);
        if (!nbt.func_74764_b("active")) {
            nbt.func_74757_a("active", false);
        }
        return nbt;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        NBTTagCompound nbt;
        nbt.func_74757_a("active", !(nbt = this.ensureTag(stack)).func_74767_n("active"));
        if (!world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(nbt.func_74767_n("active") ? "item.earthStrider.active" : "item.earthStrider.inactive", new Object[0]));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.ensureTag(stack).func_74767_n("active");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!this.ensureTag(stack).func_74767_n("active") || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        Vec3d center = Common.getTrueCenter((Entity)player);
        BlockPos foot = new BlockPos(center.field_72450_a, player.field_70163_u + 0.5, center.field_72449_c);
        NBTTagCompound nbt = CNBT.ensureCompound(stack);
        if (player.func_70093_af()) {
            if (!nbt.func_74767_n("alreadySneaking")) {
                foot = foot.func_177982_a(0, -1, 0);
            }
            nbt.func_74757_a("alreadySneaking", true);
        } else {
            nbt.func_74757_a("alreadySneaking", false);
        }
        int holeVolume = 0;
        int edgeDist = 7;
        for (BlockPos pos : CMath.cuboid(foot.func_177982_a(-edgeDist, 0, -edgeDist), foot.func_177982_a(edgeDist, 3, edgeDist))) {
            TileHole hole;
            int dx = pos.func_177958_n() - foot.func_177958_n();
            int dy = pos.func_177956_o() - foot.func_177956_o();
            int dz = pos.func_177952_p() - foot.func_177952_p();
            dx = Math.abs(dx);
            dz = Math.abs(dz);
            boolean isEdge = dx == edgeDist || dy == 3 || dz == edgeDist;
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockHole) {
                hole = (TileHole)world.func_175625_s(pos);
                if (!isEdge) {
                    hole.setTimeLeft(5);
                    ++holeVolume;
                } else {
                    hole.replace(true);
                }
            }
            if (world.field_72995_K || !(state.func_177230_c() instanceof BlockStone) || isEdge || !this.canMakeHole(world, pos)) continue;
            world.func_175656_a(pos, ModBlocks.hole.func_176223_P());
            hole = (TileHole)world.func_175625_s(pos);
            hole.setPrevState(state);
        }
        if (holeVolume >= 200 && !player.field_71075_bZ.field_75098_d) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 40));
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 40));
            stack.func_77964_b(stack.func_77952_i() + 1);
            if (stack.func_77952_i() >= stack.func_77958_k()) {
                player.field_71071_by.func_70299_a(itemSlot, new ItemStack(ModItems.earthStriderDrained));
                player.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f);
            }
        }
    }

    public boolean canMakeHole(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos n = pos.func_177972_a(dir);
            IBlockState state = world.func_180495_p(n);
            if (!(state.func_177230_c() instanceof BlockLiquid) && this.getSupportDirection(state) != dir) continue;
            return false;
        }
        return true;
    }

    public boolean supportsUp(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150351_n || block == Blocks.field_150354_m) {
            return true;
        }
        if (block instanceof BlockDoor || block instanceof BlockRailBase) {
            return true;
        }
        return block instanceof BlockRedstoneDiode || block instanceof BlockRedstoneWire;
    }

    public EnumFacing getSupportDirection(IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockTorch) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a);
        }
        if (block instanceof BlockButton) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
        }
        if (block instanceof BlockLever) {
            return ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c();
        }
        if (block instanceof BlockTripWireHook) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        }
        if (this.supportsUp(state)) {
            return EnumFacing.UP;
        }
        return null;
    }

    public int func_77647_b(int damage) {
        return 0;
    }
}

