/*
 * Decompiled with CFR 0.152.
 */
package rtk.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import rtk.common.CMath;
import rtk.item.ItemBase;

public class ItemHotplate
extends ItemBase {
    public boolean etched;

    public ItemHotplate(String name, boolean etched) {
        super(name);
        this.etched = etched;
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int dx = facing.func_82601_c();
        int dy = facing.func_96559_d();
        int dz = facing.func_82599_e();
        dx = dx == 0 ? 1 : 0;
        dy = dy == 0 ? 1 : 0;
        dz = dz == 0 ? 1 : 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean didMelt = false;
        for (int xx = x - dx; xx <= x + dx; ++xx) {
            for (int yy = y - dy; yy <= y + dy; ++yy) {
                for (int zz = z - dz; zz <= z + dz; ++zz) {
                    BlockPos pos2 = new BlockPos(xx, yy, zz);
                    Block block = world.func_180495_p(pos2).func_177230_c();
                    Block replace = null;
                    if (block == Blocks.field_150347_e || block == Blocks.field_150351_n || this.etched && block == Blocks.field_150348_b) {
                        Block block2 = replace = this.etched ? Blocks.field_150417_aV : Blocks.field_150348_b;
                    }
                    if (this.etched && block == Blocks.field_150446_ar) {
                        replace = Blocks.field_150390_bg;
                    }
                    if (this.etched && block == Blocks.field_150424_aL) {
                        replace = Blocks.field_150385_bj;
                    }
                    if (replace == null) continue;
                    didMelt = true;
                    IBlockState inBS = world.func_180495_p(pos2);
                    IBlockState outBS = replace.func_176223_P();
                    try {
                        EnumFacing blockDir = (EnumFacing)inBS.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                        outBS = outBS.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)blockDir);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    world.func_175656_a(pos2, outBS);
                    this.spawnSmoke(world, xx, yy, zz);
                }
            }
        }
        if (didMelt) {
            world.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.1f + CMath.random.nextFloat() * 0.2f, 1.0f);
        }
        player.func_184609_a(hand);
        return EnumActionResult.SUCCESS;
    }

    public void spawnSmoke(World world, int x, int y, int z) {
        for (int i = 0; i <= 10; ++i) {
            Vec3d pos = CMath.randomVector(0.5);
            Vec3d dir = CMath.randomVector(0.1f);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)x + 0.5 + pos.field_72450_a, (double)y + 0.5 + pos.field_72448_b, (double)z + 0.5 + pos.field_72449_c, dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, new int[0]);
        }
    }
}

