/*
 * Decompiled with CFR 0.152.
 */
package rtk.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import rtk.common.CNBT;
import rtk.common.CWorld;
import rtk.common.Common;
import rtk.item.ItemBase;

public class ItemTrowel
extends ItemBase {
    static int maxLength = 9;

    public ItemTrowel(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public ItemStack getBuildingStack(EntityPlayer player) {
        int nextItem = player.field_71071_by.field_70461_c + 1;
        if (nextItem > 35) {
            return null;
        }
        return player.field_71071_by.func_70301_a(nextItem);
    }

    public boolean useBlock(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        int nextItem = player.field_71071_by.field_70461_c + 1;
        ItemStack stack = this.getBuildingStack(player);
        if (stack == null || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) {
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            inv.func_70298_a(nextItem, 1);
        }
        if (stack.field_77994_a == 0) {
            this.tryRefill(player, stack, nextItem);
        }
        return true;
    }

    public void tryRefill(EntityPlayer player, ItemStack stack, int slot) {
        ItemStack refill = Common.getRefill(player, stack, 64);
        if (refill != null) {
            player.field_71071_by.func_70299_a(slot, refill);
        }
    }

    public void buildOrSelect(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, EnumFacing facing, List<BlockPos> selection) {
        BlockPos pos;
        boolean live = selection == null;
        float adjust = (float)Math.PI / 180;
        double angle = Math.round(player.field_70177_z / 90.0f) * 90;
        int dx = (int)Math.round(-Math.sin(angle * (double)adjust));
        int dz = (int)Math.round(Math.cos(angle * (double)adjust));
        if (player.func_70093_af()) {
            x += dx;
            z += dz;
        } else {
            x += facing.func_82601_c();
            y += facing.func_96559_d();
            z += facing.func_82599_e();
        }
        IBlockState bs = null;
        if (live) {
            ItemStack material = this.getBuildingStack(player);
            if (material == null) {
                return;
            }
            Block block = Block.func_149634_a((Item)material.func_77973_b());
            if (block == null) {
                return;
            }
            bs = block.func_180642_a(world, new BlockPos(x, y, z), facing, (float)x, (float)y, (float)z, material.func_77960_j(), (EntityLivingBase)player);
        }
        NBTTagCompound nbt = CNBT.ensureCompound(stack);
        int length = CNBT.ensureInt(nbt, "length", 1);
        for (int i = 0; i < length && CWorld.shouldReplace(world, pos = new BlockPos(x, y, z)) && (!live || this.useBlock(player)); ++i) {
            if (live) {
                world.func_180501_a(pos, bs, 3);
            } else {
                selection.add(pos);
            }
            x += dx;
            z += dz;
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && !world.field_72995_K) {
            NBTTagCompound nbt = CNBT.ensureCompound(stack);
            int length = CNBT.ensureInt(nbt, "length", 1) + 1;
            if (length > maxLength) {
                length = 1;
            }
            player.func_146105_b((ITextComponent)new TextComponentString(Integer.toString(length)));
            player.func_184609_a(hand);
            nbt.func_74768_a("length", length);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.buildOrSelect(stack, player, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing, null);
        player.func_184609_a(hand);
        return EnumActionResult.SUCCESS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity e, int itemSlot, boolean isSelected) {
        if (!isSelected || !worldIn.field_72995_K) {
            return;
        }
        EntityPlayer p = (EntityPlayer)e;
        if (p == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = Minecraft.func_71410_x().field_71476_x.func_178782_a();
        if (worldIn.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
            return;
        }
        EnumFacing side = Minecraft.func_71410_x().field_71476_x.field_178784_b;
        double dist = pos.func_177957_d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        if (dist > 20.25) {
            return;
        }
        ArrayList<BlockPos> selection = new ArrayList<BlockPos>();
        this.buildOrSelect(stack, p, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side, selection);
        for (BlockPos s : selection) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)s.func_177958_n() + 0.5, (double)s.func_177956_o() + 0.5, (double)s.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

