/*
 * Decompiled with CFR 0.152.
 */
package rtk.udispenser;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import rtk.common.CMath;
import rtk.entity.EntityRtkArrow;
import rtk.entity.EntityRtkTNT;
import rtk.udispenser.UDispenseBehaviorProjectile;
import rtk.udispenser.UDispenser;

public abstract class UDispenseBehavior {
    private static final HashMap<Item, UDispenseBehavior> behaviors = new HashMap();
    private final Item payloadType;

    public static UDispenseBehavior get(Item payload) {
        if (behaviors.containsKey(payload)) {
            return behaviors.get(payload);
        }
        return null;
    }

    public static void add(UDispenseBehavior behavior) {
        behaviors.put(behavior.payloadType, behavior);
    }

    public UDispenseBehavior(Item payload) {
        this.payloadType = payload;
    }

    public abstract void dispense(World var1, Vec3d var2, Vec3d var3, EntityPlayer var4, UDispenser var5);

    public static void registerBehaviors() {
        UDispenseBehavior.add(new UDispenseBehaviorProjectile(Items.field_151032_g){

            @Override
            public void fire(World world, Vec3d pos, Vec3d heading, EntityPlayer player, UDispenser dispenser) {
                EntityRtkArrow arrow = new EntityRtkArrow(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                arrow.field_70250_c = player;
                arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                arrow.func_70186_c(heading.field_72450_a, heading.field_72448_b + (player == null ? 0.1 : 0.0), heading.field_72449_c, 2.0f + (float)dispenser.getPower() * 3.0E-4f, 0.0f);
                if (dispenser.hasModifier(Item.func_150898_a((Block)Blocks.field_150335_W))) {
                    arrow.explodeOnHit = true;
                    dispenser.spendModifier(Item.func_150898_a((Block)Blocks.field_150335_W), 1);
                }
                world.func_72838_d((Entity)arrow);
            }
        });
        UDispenseBehavior.add(new UDispenseBehaviorProjectile(Item.func_150898_a((Block)Blocks.field_150335_W)){

            @Override
            public void fire(World world, Vec3d pos, Vec3d heading, EntityPlayer player, UDispenser dispenser) {
                float velocity = 2.0f + (float)dispenser.getPower() * 3.0E-4f;
                heading = heading.func_186678_a((double)velocity);
                EntityRtkTNT tnt = new EntityRtkTNT(world, pos.field_72450_a + heading.field_72450_a, pos.field_72448_b + heading.field_72448_b, pos.field_72449_c + heading.field_72449_c, (EntityLivingBase)player);
                tnt.func_70016_h(heading.field_72450_a, heading.field_72448_b, heading.field_72449_c);
                int fuse = 8 + CMath.random.nextInt(3);
                if (dispenser.hasModifier(Items.field_151007_F)) {
                    fuse *= 2;
                } else if (dispenser.hasModifier((Item)Items.field_151097_aZ)) {
                    fuse /= 2;
                }
                if (dispenser.hasModifier(Item.func_150898_a((Block)Blocks.field_150430_aB))) {
                    tnt.explodeOnImpact = true;
                }
                tnt.func_184534_a(fuse);
                world.func_72838_d((Entity)tnt);
            }
        });
        UDispenseBehavior.add(new UDispenseBehavior(Items.field_151082_bd){

            @Override
            public void dispense(World world, Vec3d pos, Vec3d heading, EntityPlayer player, UDispenser dispenser) {
                if (!dispenser.hasPayload(8)) {
                    return;
                }
                double velocity = 2.0f + (float)dispenser.getPower() * 3.0E-4f;
                heading = heading.func_186678_a(velocity);
                EntityCow cow = new EntityCow(world);
                cow.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, player != null ? player.field_70177_z : 0.0f, 0.0f);
                cow.func_70016_h(heading.field_72450_a, heading.field_72448_b, heading.field_72449_c);
                world.func_72838_d((Entity)cow);
                dispenser.spendPayload(8);
                dispenser.spendFuel(1);
                world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187737_v, SoundCategory.BLOCKS, 0.7f, 0.5f + CMath.random.nextFloat());
                world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187562_am, SoundCategory.NEUTRAL, 0.7f, 0.5f + CMath.random.nextFloat());
            }
        });
    }
}

