/*
 * Decompiled with CFR 0.152.
 */
package rtk.udispenser;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import rtk.common.CMath;
import rtk.udispenser.UDispenseBehavior;
import rtk.udispenser.UDispenser;

public abstract class UDispenseBehaviorProjectile
extends UDispenseBehavior {
    public UDispenseBehaviorProjectile(Item payload) {
        super(payload);
    }

    @Override
    public void dispense(World world, Vec3d pos, Vec3d heading, EntityPlayer player, UDispenser dispenser) {
        for (int i = 0; i < this.repeats(dispenser); ++i) {
            if (!dispenser.hasPayload(1)) {
                return;
            }
            this.fire(world, pos, CMath.randomVector(heading, 1.0, this.inaccuracy(dispenser)), player, dispenser);
            dispenser.spendFuel(1);
            dispenser.spendPayload(1);
            world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187737_v, SoundCategory.BLOCKS, 0.7f, 0.5f + CMath.random.nextFloat());
        }
    }

    public int repeats(UDispenser dispenser) {
        return dispenser.hasModifier(Items.field_151121_aF) ? 8 : 1;
    }

    public double inaccuracy(UDispenser dispenser) {
        double spread;
        double d = spread = dispenser.hasModifier(Items.field_151008_G) ? 0.25 : 1.0;
        if (dispenser.hasModifier(Items.field_151121_aF)) {
            spread *= 16.0;
        }
        return spread;
    }

    public abstract void fire(World var1, Vec3d var2, Vec3d var3, EntityPlayer var4, UDispenser var5);
}

