/*
 * Decompiled with CFR 0.152.
 */
package rtk.udispenser;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import rtk.common.Common;
import rtk.udispenser.UDispenseBehavior;

public class UDispenser {
    IInventory inventory;
    boolean isCreative;
    EntityPlayer player;

    public UDispenser(IInventory inventory, EntityPlayer player) {
        this.inventory = inventory;
        this.isCreative = player != null && player.field_71075_bZ.field_75098_d;
        this.player = player;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return UDispenser.getPower(stack) > 0;
    }

    public static int getPower(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151016_H) {
            return 8000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150335_W)) {
            return 16000;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public int getPower() {
        return UDispenser.getPower(this.inventory.func_70301_a(0));
    }

    public static void tryDispense(World world, Vec3d pos, Vec3d heading, IInventory inventory, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        UDispenser dispenser = new UDispenser(inventory, player);
        Item payload = dispenser.getPayload();
        if (payload == null) {
            return;
        }
        UDispenseBehavior behavior = UDispenseBehavior.get(payload);
        if (behavior == null) {
            return;
        }
        behavior.dispense(world, pos, heading, player, dispenser);
    }

    public boolean hasPayload(int amount) {
        return this.size(1) >= amount;
    }

    public boolean hasModifier(Item item, int amount) {
        for (int i = 2; i < 11; ++i) {
            if (this.item(i) != item || this.size(i) < amount) continue;
            return true;
        }
        return false;
    }

    public boolean hasModifier(Item item) {
        return this.hasModifier(item, 1);
    }

    public void spendFuel(int amount) {
        if (!this.isCreative) {
            this.spend(0, amount);
        }
    }

    public void spendPayload(int amount) {
        if (!this.isCreative) {
            this.spend(1, amount);
        }
    }

    public void spendModifier(Item item, int amount) {
        if (this.isCreative) {
            return;
        }
        for (int i = 2; i < 11; ++i) {
            if (this.item(i) != item) continue;
            this.spend(i, amount);
            return;
        }
    }

    public void spend(int index, int amount) {
        ItemStack stack = this.inventory.func_70301_a(index);
        this.inventory.func_70298_a(index, amount);
        this.tryRefill(index, stack);
    }

    public void tryRefill(int index, ItemStack stack) {
        if (this.isCreative || this.player == null) {
            return;
        }
        int currentAmount = this.size(index);
        ItemStack refill = Common.getRefill(this.player, stack, 64 - currentAmount);
        if (refill == null) {
            return;
        }
        stack = stack.func_77946_l();
        stack.field_77994_a = currentAmount + refill.field_77994_a;
        this.inventory.func_70299_a(index, stack);
    }

    public Item getPayload() {
        return this.item(1);
    }

    public ItemStack getPayloadStack() {
        return this.inventory.func_70301_a(1);
    }

    private int size(int index) {
        return this.size(this.inventory.func_70301_a(index));
    }

    private int size(ItemStack stack) {
        return stack == null ? 0 : stack.field_77994_a;
    }

    private Item item(int index) {
        return this.item(this.inventory.func_70301_a(index));
    }

    private Item item(ItemStack stack) {
        return stack == null ? null : stack.func_77973_b();
    }
}

