/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.gui.component;

import engineers.workshop.client.gui.GuiBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ArrowScroll {
    private int x;
    private int y;
    private int width;
    private boolean clicked;
    private static final int ARROW_SRC_X = 36;
    private static final int ARROW_SRC_Y = 112;
    private static final int ARROW_W = 6;
    private static final int ARROW_H = 10;
    private static final int TEXT_Y = 3;

    public ArrowScroll(int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.width = width;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBase gui, int mX, int mY) {
        if (this.isVisible()) {
            gui.prepare();
            boolean left = this.drawArrow(gui, mX, mY, true);
            boolean right = this.drawArrow(gui, mX, mY, false);
            if (!left && !right) {
                this.clicked = false;
            }
            gui.drawCenteredString(this.getText(), this.x + 6, this.y + 3, this.width - 6, 0.7f, 0x1E1E1E);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean drawArrow(GuiBase gui, int mX, int mY, boolean left) {
        int srcX = 36 + (left ? 0 : 6);
        boolean hover = this.inArrowBounds(gui, mX, mY, left);
        int srcY = 112 + (hover ? (this.clicked ? 1 : 2) : 0) * 10;
        gui.drawRect(left ? this.x : this.x + this.width, this.y, srcX, srcY, 6, 10);
        return hover;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean inArrowBounds(GuiBase gui, int mX, int mY, boolean left) {
        return gui.inBounds(left ? this.x : this.x + this.width, this.y, 6, 10, mX, mY);
    }

    public boolean isVisible() {
        return true;
    }

    public void onUpdate() {
    }

    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiBase gui, int mX, int mY) {
        if (this.inArrowBounds(gui, mX, mY, true)) {
            int id = this.getId();
            if (--id < 0) {
                id = this.getLength() - 1;
            }
            this.clicked = true;
            this.setId(id);
            this.onUpdate();
        } else if (this.inArrowBounds(gui, mX, mY, false)) {
            int id = this.getId();
            if (++id >= this.getLength()) {
                id = 0;
            }
            this.clicked = true;
            this.setId(id);
            this.onUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRelease() {
        this.clicked = false;
    }

    public abstract String getText();

    public abstract void setId(int var1);

    public abstract int getId();

    protected abstract int getLength();
}

