/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.gui.menu;

import engineers.workshop.client.gui.GuiBase;
import engineers.workshop.client.gui.component.Button;
import engineers.workshop.common.table.TileTable;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GuiMenu {
    protected List<Button> buttons;
    protected TileTable table;

    public GuiMenu(TileTable table) {
        this.table = table;
        this.buttons = new ArrayList<Button>();
        this.buttons.add(new Button("Save", 150, 230){

            @Override
            public void clicked() {
                GuiMenu.this.save();
                GuiMenu.this.close();
            }
        });
        this.buttons.add(new Button("Cancel", 200, 230){

            @Override
            public void clicked() {
                GuiMenu.this.close();
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBase gui, int mX, int mY) {
        for (Button button : this.buttons) {
            button.draw(gui, mX, mY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiBase gui, int mX, int mY) {
        for (Button button : this.buttons) {
            button.onClick(gui, mX, mY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRelease(GuiBase gui, int mX, int mY) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onKeyStroke(GuiBase gui, char c, int k) {
    }

    protected abstract void save();

    protected void close() {
        this.table.setMenu(null);
    }
}

