/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.gui.page;

import engineers.workshop.client.gui.GuiBase;
import engineers.workshop.client.gui.page.Page;
import engineers.workshop.client.gui.page.unit.Unit;
import engineers.workshop.client.gui.page.unit.UnitCrafting;
import engineers.workshop.client.gui.page.unit.UnitSmelting;
import engineers.workshop.common.table.TileTable;
import java.util.ArrayList;
import java.util.List;

public class PageMain
extends Page {
    private List<Unit> units = new ArrayList<Unit>();
    private List<UnitCrafting> craftingList = new ArrayList<UnitCrafting>();
    private List<UnitSmelting> smeltingList = new ArrayList<UnitSmelting>();
    public static final int WIDTH = 256;
    public static final int HEIGHT = 174;
    private static final int TEXTURE_SHEET_SIZE = 256;
    private static final int BAR_THICKNESS = 4;
    private static final int BAR_WIDTH = 240;
    private static final int BAR_HEIGHT = 162;
    private static final int BAR_HORIZONTAL_X = 8;
    private static final int BAR_HORIZONTAL_Y = 85;
    private static final int BAR_VERTICAL_X = 126;
    private static final int BAR_VERTICAL_Y = 6;

    public PageMain(TileTable table, String name) {
        super(table, name);
        for (int i = 0; i < 4; ++i) {
            this.addUnit(i);
        }
    }

    private void addUnit(int id) {
        int x = id % 2 * 256 / 2;
        int y = id / 2 * 174 / 2;
        UnitCrafting crafting = new UnitCrafting(this.table, this, id, x, y);
        UnitSmelting smelting = new UnitSmelting(this.table, this, id, x, y);
        this.craftingList.add(crafting);
        this.smeltingList.add(smelting);
        this.units.add(crafting);
        this.units.add(smelting);
    }

    public List<UnitSmelting> getSmeltingList() {
        return this.smeltingList;
    }

    public List<UnitCrafting> getCraftingList() {
        return this.craftingList;
    }

    @Override
    public void onUpdate() {
        this.units.stream().filter(Unit::isEnabled).forEachOrdered(Unit::onUpdate);
    }

    @Override
    public int createSlots(int id) {
        for (Unit unit : this.units) {
            id = unit.createSlots(id);
        }
        return id;
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        gui.prepare();
        gui.drawRect(8, 85, 0, 252, 240, 4);
        gui.drawRect(126, 6, 252, 0, 4, 162);
        this.units.stream().filter(Unit::isEnabled).forEachOrdered(unit -> unit.draw(gui, mX, mY));
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int button) {
        this.units.stream().filter(Unit::isEnabled).forEachOrdered(unit -> unit.onClick(gui, mX, mY));
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    @Override
    public String getDesc() {
        return "Workshop Area";
    }
}

