/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.gui.page.setting;

import engineers.workshop.client.gui.page.setting.Setting;
import engineers.workshop.client.gui.page.setting.Transfer;
import engineers.workshop.common.items.Upgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class Side {
    private int x;
    private int y;
    private EnumFacing direction;
    private Setting setting;
    private Transfer input;
    private Transfer output;

    public Side(Setting setting, EnumFacing direction, int x, int y) {
        this.x = x;
        this.y = y;
        this.direction = direction;
        this.setting = setting;
        this.input = new Transfer(true);
        this.output = new Transfer(false);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isOutputEnabled() {
        return this.output.isEnabled();
    }

    public boolean isInputEnabled() {
        return this.input.isEnabled();
    }

    public void setOutputEnabled(boolean value) {
        this.output.setEnabled(value);
    }

    public void setInputEnabled(boolean value) {
        this.input.setEnabled(value);
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public Setting getSetting() {
        return this.setting;
    }

    public Transfer getOutput() {
        return this.output;
    }

    public Transfer getInput() {
        return this.input;
    }

    public List<String> getDescription(boolean selected) {
        ArrayList<String> str = new ArrayList<String>();
        str.add(StringUtils.capitalize((String)this.direction.func_176610_l()));
        if (selected) {
            str.add(TextFormatting.YELLOW + "Selected");
        }
        str.add("");
        this.addTransferInfo(str, this.input, TextFormatting.BLUE);
        this.addTransferInfo(str, this.output, TextFormatting.RED);
        return str;
    }

    private void addTransferInfo(List<String> lst, Transfer transfer, TextFormatting color) {
        String name;
        String string = name = transfer.isInput() ? "Input" : "Output";
        if (transfer.isEnabled()) {
            lst.add(color + name + ": Enabled");
            if (transfer.isAuto() && this.setting.table.getUpgradePage().hasGlobalUpgrade(Upgrade.AUTO_TRANSFER)) {
                lst.add(TextFormatting.GRAY + name + " Transfer: " + TextFormatting.GREEN + "Auto");
            }
            if (transfer.hasFilter(this.setting.table)) {
                if (transfer.hasWhiteList()) {
                    lst.add(TextFormatting.GRAY + name + " Filter: " + TextFormatting.WHITE + "White list");
                } else {
                    lst.add(TextFormatting.GRAY + name + " Filter: " + TextFormatting.DARK_GRAY + "Black list");
                }
            }
        } else {
            lst.add(TextFormatting.GRAY + name + ": Disabled");
        }
    }
}

