/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.items;

import engineers.workshop.common.loaders.ItemLoader;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum Upgrade {
    BLANK(new MaxCount(0), ParentType.NULL),
    AUTO_CRAFTER(new MaxCount(1), ParentType.CRAFTING),
    STORAGE(new MaxCount(1), ParentType.CRAFTING),
    CHARGED((MaxCount)new ConfigurableMax(8), ParentType.NULL),
    SPEED((MaxCount)new ConfigurableMax(8), ParentType.BOTH),
    QUEUE(new MaxCount(3), ParentType.SMELTING),
    EFFICIENCY((MaxCount)new ConfigurableMax(4), ParentType.GLOBAL),
    RF(new MaxCount(1), ParentType.GLOBAL),
    SOLAR((MaxCount)new ConfigurableMax(4), ParentType.GLOBAL),
    AUTO_TRANSFER(new MaxCount(1), ParentType.GLOBAL),
    FILTER(new MaxCount(1), ParentType.GLOBAL),
    TRANSFER((MaxCount)new ConfigurableMax(6, 20), ParentType.GLOBAL),
    MAX_POWER((MaxCount)new ConfigurableMax(16), ParentType.GLOBAL),
    FUEL_DELAY((MaxCount)new ConfigurableMax(5), ParentType.GLOBAL);

    private String name;
    private String description;
    private MaxCount maxCount;
    private EnumSet<ParentType> validParents;

    private Upgrade(MaxCount maxCount, EnumSet<ParentType> validParents) {
        this.validParents = validParents;
        this.name = this.toString().toLowerCase();
        this.description = String.format("engineersworkshop:upgrade.%s.description", this.name);
        this.maxCount = maxCount;
        maxCount.init(this);
    }

    private Upgrade(MaxCount maxCount, ParentType type) {
        this(maxCount, type == null || type == ParentType.NULL ? EnumSet.noneOf(ParentType.class) : (type == ParentType.BOTH ? EnumSet.of(ParentType.CRAFTING, ParentType.SMELTING) : EnumSet.of(type)));
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.maxCount.getConfigurableMax() == 0 || this.maxCount.getMax() > 0;
    }

    public ItemStack getItemStack() {
        return new ItemStack(ItemLoader.itemUpgrade, 1, this.ordinal());
    }

    public static ItemStack getInvalidItemStack() {
        return new ItemStack(ItemLoader.itemUpgrade, 1, Upgrade.values().length);
    }

    public void addInfo(List<String> info) {
        info.add(I18n.func_135052_a((String)this.description, (Object[])new Object[0]));
        if (!GuiScreen.func_146272_n() && !GuiScreen.func_146271_m()) {
            info.add(I18n.func_135052_a((String)"<hold shift for stack info>", (Object[])new Object[0]));
            info.add(I18n.func_135052_a((String)"<hold control for parent info>", (Object[])new Object[0]));
        }
        if (GuiScreen.func_146272_n()) {
            if (this.getMaxCount() == 1) {
                info.add(I18n.func_135052_a((String)"engineersworkshop:upgrade.unstackable", (Object[])new Object[0]));
            } else if (this.getMaxCount() > 1) {
                info.add(I18n.func_135052_a((String)"engineersworkshop:upgrade.stackable", (Object[])new Object[]{this.getMaxCount()}));
            }
            info.addAll(this.validParents.stream().map(validParent -> I18n.func_135052_a((String)((ParentType)validParent).description, (Object[])new Object[0])).collect(Collectors.toList()));
        }
        if (GuiScreen.func_146271_m() && this.validParents.size() > 0) {
            info.add("Parents: ");
            info.addAll(this.validParents.stream().map(Enum::name).collect(Collectors.toList()));
        }
    }

    public boolean isValid(ItemStack parent) {
        for (ParentType validParent : this.validParents) {
            if (!validParent.isValidParent(parent)) continue;
            return true;
        }
        return false;
    }

    public int getMaxCount() {
        return this.maxCount.getMax();
    }

    public MaxCount getMaxCountObject() {
        return this.maxCount;
    }

    private static class ConfigurableMax
    extends MaxCount {
        private boolean isGlobal;
        private int configurableMax;
        private static final int GLOBAL_MAX_COUNT = 512;
        private static final int MAX_COUNT = 448;

        private ConfigurableMax(int max, int configurableMax) {
            super(max);
            this.configurableMax = configurableMax;
        }

        private ConfigurableMax(int max) {
            this(max, -1);
        }

        @Override
        public int getConfigurableMax() {
            return this.configurableMax != -1 ? this.configurableMax : (this.isGlobal ? 512 : 448);
        }

        @Override
        public void init(Upgrade upgrade) {
            this.isGlobal = upgrade.validParents.contains((Object)ParentType.GLOBAL);
        }
    }

    public static class MaxCount {
        private int max;
        private int defaultMax;

        public MaxCount(int max) {
            this.max = max;
            this.defaultMax = max;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int value) {
            this.max = value;
        }

        public int getConfigurableMax() {
            return this.defaultMax;
        }

        public void init(Upgrade upgrade) {
        }
    }

    public static enum ParentType {
        CRAFTING("Works with Crafting Tables"){

            @Override
            protected boolean isValidParent(ItemStack item) {
                return item != null && Item.func_150898_a((Block)Blocks.field_150462_ai).equals(item.func_77973_b());
            }
        }
        ,
        SMELTING("Works with Furnaces"){

            @Override
            protected boolean isValidParent(ItemStack item) {
                return item != null && Item.func_150898_a((Block)Blocks.field_150460_al).equals(item.func_77973_b());
            }
        }
        ,
        GLOBAL("Upgrades the entire Production Table"){

            @Override
            protected boolean isValidParent(ItemStack item) {
                return item == null;
            }
        }
        ,
        BOTH("upgrade.both"){

            @Override
            protected boolean isValidParent(ItemStack item) {
                return CRAFTING.isValidParent(item) || SMELTING.isValidParent(item);
            }
        }
        ,
        NULL("upgrade.null"){

            @Override
            protected boolean isValidParent(ItemStack item) {
                return false;
            }
        };

        private String description;

        private ParentType(String description) {
            this.description = description;
        }

        protected abstract boolean isValidParent(ItemStack var1);
    }
}

