/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.loaders;

import engineers.workshop.common.items.Upgrade;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

@GameRegistry.ObjectHolder(value="engineersworkshop")
public final class ConfigLoader {
    public static void loadConfig(File file) {
        Configuration config = new Configuration(file);
        config.load();
        new UPGRADES(config, "Upgrades").load();
        new TWEAKS(config, "Tweaks").load();
        new POWER(config, "Power").load();
        config.save();
    }

    public static class POWER
    extends ConfigHandler {
        public static boolean TESLA_SUPPORT;
        public static boolean RF_SUPPORT;

        public POWER(Configuration config, String category) {
            super(config, category);
        }

        @Override
        public void load() {
            TESLA_SUPPORT = this.config.getBoolean("Tesla Support", "Power", true, "Should Tesla upgrades be allowed? (Requires Tesla)");
            RF_SUPPORT = this.config.getBoolean("RF Support", "Power", true, "Should Tesla upgrades be allowed? (Requires Tesla)");
        }
    }

    public static class TWEAKS
    extends ConfigHandler {
        public static int FUEL_DELAY;
        public static int MIN_POWER;
        public static int POWER_CONVERSION;

        public TWEAKS(Configuration config, String category) {
            super(config, category);
        }

        @Override
        public void load() {
            FUEL_DELAY = this.config.getInt("Fuel Delay", this.category, 15, 0, Integer.MAX_VALUE, "Sets the amount of ticks between each time the worktable consumes a fuel resource");
            MIN_POWER = this.config.getInt("Max Power", this.category, 8000, 1, Integer.MAX_VALUE, "Sets the default max power in the workshop table (minimum, since upgrades can only add power)");
            POWER_CONVERSION = this.config.getInt("Power Conversion Rate", this.category, 8, 1, Integer.MAX_VALUE, "Power conversion rate [x:1] [x = external power input]");
        }
    }

    public static class UPGRADES
    extends ConfigHandler {
        public static int SOLAR_GENERATION;
        public static int FUEL_EFFICIENCY_CHANGE;
        public static int MAX_POWER_CHANGE;
        public static int FUEL_DELAY_CHANGE;
        private final String MAX_COUNT_SUFFIX = " maximum amount";

        public UPGRADES(Configuration config, String category) {
            super(config, category);
        }

        @Override
        public void load() {
            for (Upgrade upgrade : Upgrade.values()) {
                Upgrade.MaxCount max = upgrade.getMaxCountObject();
                if (max.getConfigurableMax() <= 0) continue;
                upgrade.getMaxCountObject().setMax(this.config.getInt(upgrade.getName() + " maximum amount", this.category, max.getMax(), 0, max.getConfigurableMax(), "Max amount of the " + upgrade.getName() + " upgrade"));
            }
            SOLAR_GENERATION = this.config.getInt("Solar Generation", this.category, 4, 0, Integer.MAX_VALUE, "Sets the amount of energy generated per tick per solar panel upgrade in the workshop table");
            FUEL_EFFICIENCY_CHANGE = this.config.getInt("Fuel Efficiency Change", this.category, 4, 0, Integer.MAX_VALUE, "Sets how efficient each upgrade is, formula: 'power = fuel * (upgradeAmount / this)'");
            MAX_POWER_CHANGE = this.config.getInt("Max Power Change", this.category, 1000, 0, Integer.MAX_VALUE, "Sets the amount that each max power upgrade increases the max power by.");
            FUEL_DELAY_CHANGE = this.config.getInt("Fuel Delay Change", this.category, 1, 0, 14, "Sets the amount that each fuel delay upgrade decreases the fuel delay by.");
        }
    }

    private static abstract class ConfigHandler {
        protected String category;
        protected Configuration config;

        public ConfigHandler(Configuration config, String category) {
            this.category = category;
            this.config = config;
        }

        public abstract void load();
    }
}

