/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.network;

import engineers.workshop.client.gui.container.ContainerTable;
import engineers.workshop.common.network.DataReader;
import engineers.workshop.common.network.DataWriter;
import engineers.workshop.common.network.PacketId;
import engineers.workshop.common.table.TileTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.onPacket((FMLNetworkEvent.CustomPacketEvent)event, (EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.onPacket((FMLNetworkEvent.CustomPacketEvent)event, (EntityPlayer)((NetHandlerPlayServer)event.getHandler()).field_147369_b, true);
    }

    private void onPacket(FMLNetworkEvent.CustomPacketEvent event, EntityPlayer player, boolean onServer) {
        DataReader dr = new DataReader(event.getPacket().payload());
        PacketId id = dr.readEnum(PacketId.class);
        TileTable table = null;
        if (id.isInInterface()) {
            if (player.field_71070_bA instanceof ContainerTable) {
                table = ((ContainerTable)player.field_71070_bA).getTable();
            }
        } else {
            int z;
            int y;
            World world = player.field_70170_p;
            int x = dr.readSignedInteger();
            TileEntity te = world.func_175625_s(new BlockPos(x, y = dr.readSignedInteger(), z = dr.readSignedInteger()));
            if (te instanceof TileTable) {
                table = (TileTable)te;
            }
        }
        if (table != null) {
            if (onServer) {
                table.receiveServerPacket(dr, id, player);
            } else {
                table.receiveClientPacket(dr, id);
            }
        }
    }

    public static DataWriter getWriter(TileTable table, PacketId id) {
        DataWriter dw = new DataWriter();
        dw.writeEnum(id);
        if (!id.isInInterface()) {
            dw.writeInteger(table.func_174877_v().func_177958_n());
            dw.writeInteger(table.func_174877_v().func_177956_o());
            dw.writeInteger(table.func_174877_v().func_177952_p());
        }
        return dw;
    }

    public static void sendToPlayer(DataWriter dw, EntityPlayer player) {
        dw.sendToPlayer((EntityPlayerMP)player);
    }

    public static void sendToServer(DataWriter dw) {
        dw.sendToServer();
    }
}

