/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.justsleep;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import me.modmuss50.justsleep.SetPlayerSpawnPacket;
import me.modmuss50.justsleep.SyncBedStatusPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.Validate;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.RegisterPacketEvent;

@Mod.EventBusSubscriber
@Mod(modid="justsleep", name="Just Sleep", dependencies="required-after:reborncore", version="1.0.0.1", acceptedMinecraftVersions="[1.12.2]")
public class JustSleep {
    static Set<String> playerSpawnSetSkip = new HashSet<String>();
    private static HashMap<String, BlockPos> validBedMap = new HashMap();

    @SubscribeEvent
    public static void spawnSet(PlayerSetSpawnEvent event) {
        String uuid = event.getEntityPlayer().func_110124_au().toString();
        if (playerSpawnSetSkip.contains(uuid)) {
            playerSpawnSetSkip.remove(uuid);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void wakeUp(PlayerWakeUpEvent event) {
        if (event.shouldSetSpawn()) {
            String uuid = event.getEntityPlayer().func_110124_au().toString();
            if (JustSleep.hasValidBedLocation(event.getEntityPlayer())) {
                playerSpawnSetSkip.add(uuid);
            }
        }
    }

    @SubscribeEvent
    public static void sleep(PlayerSleepInBedEvent event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && event.getEntityPlayer() instanceof EntityPlayerMP) {
            JustSleep.updateBedMap((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    public static boolean hasValidBedLocation(EntityPlayer player) {
        return JustSleep.getBedLocation(player) != null;
    }

    public static BlockPos getBedLocation(EntityPlayer player) {
        String uuid = player.func_110124_au().toString();
        if (player.field_70170_p.field_72995_K) {
            return validBedMap.getOrDefault(uuid, null);
        }
        BlockPos bedLocation = player.getBedLocation(player.field_71093_bK);
        if (bedLocation == null) {
            return null;
        }
        BlockPos bedSpawnLocation = EntityPlayer.func_180467_a((World)player.field_70170_p, (BlockPos)bedLocation, (boolean)false);
        return bedSpawnLocation;
    }

    @SubscribeEvent
    public static void registerPacket(RegisterPacketEvent event) {
        event.registerPacket(SetPlayerSpawnPacket.class, Side.SERVER);
        event.registerPacket(SyncBedStatusPacket.class, Side.CLIENT);
    }

    public static void updateClientBedLocation(EntityPlayer player, BlockPos pos) {
        Validate.isTrue((boolean)player.field_70170_p.field_72995_K);
        String uuid = player.func_110124_au().toString();
        validBedMap.remove(uuid);
        validBedMap.put(uuid, pos);
    }

    public static void updateBedMap(EntityPlayerMP player) {
        BlockPos pos = player.getBedLocation(player.field_71093_bK);
        if (!JustSleep.hasValidBedLocation((EntityPlayer)player)) {
            pos = null;
        }
        NetworkManager.sendToPlayer((INetworkPacket)new SyncBedStatusPacket(pos), (EntityPlayerMP)player);
    }
}

