/*
 * Decompiled with CFR 0.152.
 */
package ghostwolf.simplyloaders.tileentities;

import ghostwolf.simplyloaders.Config;
import java.util.List;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityLoaderBase
extends TileEntity
implements ICapabilityProvider,
ITickable {
    public boolean isEmittingRedstone = false;
    public int transferRate = Config.LoaderTransferRate;

    public TileEntity getChest() {
        IItemHandler itemHandler;
        TileEntity Te = this.func_145831_w().func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()));
        if (Te != null && (itemHandler = (IItemHandler)Te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            return Te;
        }
        if (!this.isEmittingRedstone) {
            this.updateRedstone(true);
        }
        return null;
    }

    public boolean chestHasItem(IItemHandler chest) {
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack inslot = chest.getStackInSlot(i);
            if (inslot == null || inslot.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public EntityMinecartChest getChestCart() {
        List L = this.func_145831_w().func_72872_a(EntityMinecartChest.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 1)));
        if (!L.isEmpty()) {
            return (EntityMinecartChest)L.get(0);
        }
        return null;
    }

    public void moveItem(IItemHandler chest, IItemHandler cart) {
        boolean itemMoved = false;
        for (int i = 0; i < chest.getSlots(); ++i) {
            if (!chest.getStackInSlot(i).func_190926_b()) {
                ItemStack extractedItems = chest.extractItem(i, this.transferRate, true);
                for (int x = 0; x < cart.getSlots(); ++x) {
                    ItemStack insertedItems = cart.insertItem(x, extractedItems, true);
                    if (!insertedItems.func_190926_b()) continue;
                    ItemStack exI = chest.extractItem(i, this.transferRate, false);
                    ItemStack inI = cart.insertItem(x, exI, false);
                    itemMoved = true;
                    break;
                }
            }
            if (itemMoved) break;
        }
        if (!itemMoved) {
            this.updateRedstone(true);
        }
    }

    public void updateRedstone(boolean value) {
        if (!this.func_145831_w().field_72995_K) {
            this.isEmittingRedstone = value;
            this.func_145831_w().func_175685_c(this.func_174877_v(), Blocks.field_150318_D, false);
        }
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.tick();
        }
    }

    public void tick() {
    }

    public void setTransferRate(int rate) {
        this.transferRate = rate;
    }
}

