/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.Block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import pcl.OpenFM.GUI.GuiRadioBase;
import pcl.OpenFM.OpenFM;
import pcl.OpenFM.TileEntity.TileEntityRadio;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")})
public class BlockRadio
extends Block
implements ITileEntityProvider {
    public GuiRadioBase guiRadio;
    private Random random;
    public static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockRadio() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149663_c("OpenFM.Radio");
        this.func_149672_a(Block.field_149766_f);
        this.random = new Random();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)OpenFM.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityRadio t = (TileEntityRadio)world.func_175625_s(pos);
        this.dropContent(t, world, t.func_174877_v().func_177958_n(), t.func_174877_v().func_177956_o(), t.func_174877_v().func_177952_p());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (t instanceof TileEntityRadio && t.stations.size() > 0) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1);
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a("streamurl", t.streamURL);
            stack.func_77978_p().func_74778_a("screenText", t.getScreenText());
            stack.func_77978_p().func_74768_a("screenColor", t.getScreenColor());
            for (int i = 0; i < t.getStationCount(); ++i) {
                stack.func_77978_p().func_74778_a("station" + i, t.stations.get(i));
                stack.func_77978_p().func_74768_a("stationCount", i + 1);
            }
            items.add(stack);
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)items.get(0)));
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        int facingbits = facing.func_176736_b();
        return facingbits;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{PROPERTYFACING});
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return null;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        TileEntity te = world.func_175625_s(pos);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void onNeighborBlockChange(World world, BlockPos pos, Block block) {
        boolean flag = world.func_175640_z(pos);
        try {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            if (block.func_149744_f()) {
                TileEntity tileEntity = side == Side.SERVER ? MinecraftServer.func_71276_C().func_130014_f_().func_175625_s(pos) : FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(pos);
                ((TileEntityRadio)tileEntity).setRedstoneInput(flag);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dropContent(IInventory chest, World world, int xCoord, int yCoord, int zCoord) {
        if (chest == null) {
            return;
        }
        for (int i1 = 0; i1 < chest.func_70302_i_(); ++i1) {
            ItemStack itemstack = chest.func_70301_a(i1);
            if (itemstack == null) continue;
            float offsetX = this.random.nextFloat() * 0.8f + 0.1f;
            float offsetY = this.random.nextFloat() * 0.8f + 0.1f;
            float offsetZ = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int stackSize = this.random.nextInt(21) + 10;
                if (stackSize > itemstack.field_77994_a) {
                    stackSize = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= stackSize;
                EntityItem entityitem = new EntityItem(world, (double)((float)xCoord + offsetX), (double)((float)yCoord + offsetY), (double)((float)zCoord + offsetZ), new ItemStack(itemstack.func_77973_b(), stackSize, itemstack.func_77952_i()));
                float velocity = 0.05f;
                entityitem.field_70159_w = (float)this.random.nextGaussian() * velocity;
                entityitem.field_70181_x = (float)this.random.nextGaussian() * velocity + 0.2f;
                entityitem.field_70179_y = (float)this.random.nextGaussian() * velocity;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityRadio(world);
    }
}

