/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.player;

import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.advanced.PlaybackEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import pcl.OpenFM.ContentRegistry;
import pcl.OpenFM.player.PlayBackEvent;
import pcl.OpenFM.player.PlaybackListener;

public class AdvancedPlayer {
    private Bitstream bitstream;
    private Decoder decoder;
    private AudioDevice audio;
    private PlaybackListener listener;
    private float volume = 0.0f;
    private int posX;
    private int posY;
    private int posZ;
    private World world;
    public InputStream ourStream = null;

    public AdvancedPlayer(InputStream stream) throws JavaLayerException {
        this(stream, null);
    }

    public void setID(World w, int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.world = w;
    }

    public AdvancedPlayer(InputStream stream, AudioDevice device) throws JavaLayerException {
        this.ourStream = stream;
        this.bitstream = new Bitstream(stream);
        this.audio = device != null ? device : FactoryRegistry.systemRegistry().createAudioDevice();
        this.decoder = new Decoder();
        this.audio.open(this.decoder);
    }

    public void play() throws JavaLayerException {
        this.play(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play(int frames) throws JavaLayerException {
        boolean ret = true;
        if (this.listener != null) {
            this.listener.playbackStarted(this.createEvent(PlaybackEvent.STARTED));
        }
        while (frames-- > 0 && ret) {
            if (!ContentRegistry.checkBlock(this.world, new BlockPos(this.posX, this.posY, this.posZ))) {
                this.close();
            }
            ret = this.decodeFrame();
        }
        AudioDevice out = this.audio;
        if (out != null) {
            out.flush();
            AdvancedPlayer advancedPlayer = this;
            synchronized (advancedPlayer) {
                this.close();
            }
            if (this.listener != null) {
                this.listener.playbackFinished(this.createEvent(out, PlaybackEvent.STOPPED));
            }
        }
        return ret;
    }

    public synchronized void close() {
        AudioDevice out = this.audio;
        if (out != null) {
            this.audio = null;
            out.close();
            out.getPosition();
            try {
                this.bitstream.close();
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean decodeFrame() throws JavaLayerException {
        try {
            AudioDevice out = this.audio;
            if (out == null) {
                return false;
            }
            Header h = this.bitstream.readFrame();
            if (h == null) {
                return false;
            }
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
            AdvancedPlayer advancedPlayer = this;
            synchronized (advancedPlayer) {
                out = this.audio;
                if (out != null) {
                    short[] samples = output.getBuffer();
                    for (int samp = 0; samp < samples.length; ++samp) {
                        samples[samp] = (short)((float)samples[samp] * this.volume * (Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.RECORDS) * Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.MASTER)));
                    }
                    out.write(samples, 0, output.getBufferLength());
                }
            }
            this.bitstream.closeFrame();
        }
        catch (RuntimeException ex) {
            this.stop();
            throw new JavaLayerException("Exception decoding audio frame", ex);
        }
        return true;
    }

    protected boolean skipFrame() throws JavaLayerException {
        Header h = this.bitstream.readFrame();
        if (h == null) {
            return false;
        }
        this.bitstream.closeFrame();
        return true;
    }

    public boolean play(int start, int end) throws JavaLayerException {
        boolean ret = true;
        int offset = start;
        while (offset-- > 0 && ret) {
            ret = this.skipFrame();
        }
        return this.play(end - start);
    }

    private PlayBackEvent createEvent(int id) {
        return this.createEvent(this.audio, id);
    }

    private PlayBackEvent createEvent(AudioDevice dev, int id) {
        return new PlayBackEvent(this, id, dev.getPosition());
    }

    public void setPlayBackListener(PlaybackListener listener) {
        this.listener = listener;
    }

    public PlaybackListener getPlayBackListener() {
        return this.listener;
    }

    public void stop() {
        this.listener.playbackFinished(this.createEvent(PlayBackEvent.STOPPED));
        this.close();
    }

    public void setVolume(float f) {
        this.volume = f;
    }

    public float getVolume() {
        return this.volume;
    }
}

