/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.player;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pcl.OpenFM.OpenFM;
import pcl.OpenFM.network.Message.MessageTERadioBlock;
import pcl.OpenFM.network.PacketHandler;
import pcl.OpenFM.player.AdvancedPlayer;
import pcl.OpenFM.player.OGGPlayer;
import pcl.OpenFM.player.PlayBackEvent;
import pcl.OpenFM.player.PlaybackListener;

public class PlayerDispatcher
extends PlaybackListener
implements Runnable {
    private String streamURL;
    public AdvancedPlayer mp3Player;
    public OGGPlayer oggPlayer;
    public String decoder;
    private Thread pThread;
    private int x;
    private int y;
    private int z;
    private World world;

    public PlayerDispatcher(String decoder, String mp3url, World w, int a, int b, int c) {
        try {
            this.world = w;
            this.decoder = decoder;
            this.x = a;
            this.y = b;
            this.z = c;
            this.streamURL = mp3url;
            this.pThread = new Thread(this);
            this.pThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            if (this.decoder.equals("mp3")) {
                OkHttpClient client = new OkHttpClient();
                Request request = new Request.Builder().url(this.streamURL).build();
                Response response = client.newCall(request).execute();
                InputStream stream = response.body().byteStream();
                this.mp3Player = new AdvancedPlayer(stream);
                this.mp3Player.setID(this.world, this.x, this.y, this.z);
                this.mp3Player.setPlayBackListener(this);
                this.mp3Player.play();
            } else if (this.decoder.equals("ogg")) {
                this.oggPlayer = new OGGPlayer();
                this.oggPlayer.setID(this.world, this.x, this.y, this.z);
                this.oggPlayer.play(this.streamURL);
            }
        }
        catch (Exception e) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTERadioBlock((double)this.x, (double)this.y, (double)this.z, this.world, this.streamURL, !this.isPlaying(), 0.1f, 1));
            FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.OpenFM.invalid_link", new Object[0]));
            OpenFM.logger.error((Object)e);
        }
    }

    public void stop() {
        if ((this.mp3Player != null || this.oggPlayer != null) && this.isPlaying()) {
            if (this.decoder.equals("mp3")) {
                this.mp3Player.stop();
            } else if (this.decoder.equals("ogg")) {
                this.oggPlayer.stop();
            }
        }
    }

    @Override
    public void playbackStarted(PlayBackEvent evt) {
    }

    @Override
    public void playbackFinished(PlayBackEvent evt) {
    }

    public boolean isPlaying() {
        if (this.decoder.equals("mp3")) {
            return this.pThread.isAlive();
        }
        if (this.decoder.equals("ogg")) {
            return this.oggPlayer.isPlaying();
        }
        return false;
    }

    public void setVolume(float f) {
        if (this.mp3Player != null) {
            this.mp3Player.setVolume(f);
        } else if (this.oggPlayer != null) {
            this.oggPlayer.setVolume(f);
        }
    }

    public float getVolume() {
        if (this.decoder.equals("mp3")) {
            return this.mp3Player.getVolume() / Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.RECORDS);
        }
        if (this.decoder.equals("ogg")) {
            return this.oggPlayer.getVolume() / Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.RECORDS);
        }
        return 0.0f;
    }
}

