/*
 * Decompiled with CFR 0.152.
 */
package com.mawnt.storageboats.entity.model;

import com.mawnt.storageboats.entity.EntityStorageBoat;
import com.mawnt.storageboats.entity.model.ModelStorageBoat;
import com.mawnt.storageboats.entity.model.ModelStorageBoat2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBoat;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderStorageBoat
extends Render<EntityStorageBoat> {
    private static final ResourceLocation[] BOAT_TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/boat/boat_oak.png"), new ResourceLocation("textures/entity/boat/boat_spruce.png"), new ResourceLocation("textures/entity/boat/boat_birch.png"), new ResourceLocation("textures/entity/boat/boat_jungle.png"), new ResourceLocation("textures/entity/boat/boat_acacia.png"), new ResourceLocation("textures/entity/boat/boat_darkoak.png")};
    private static final ResourceLocation CHEST_TEXTURES = new ResourceLocation("textures/entity/chest/normal.png");
    private static final ResourceLocation ENDER_CHEST_TEXTURES = new ResourceLocation("textures/entity/chest/ender.png");
    private static final ResourceLocation FURNACE_TEXTURES = new ResourceLocation("storageboats:textures/models/furnace.png");
    private static final ResourceLocation HOPPER_TEXTURES = new ResourceLocation("storageboats:textures/models/hopper.png");
    private static final ResourceLocation LIT_FURNACE_TEXTURES = new ResourceLocation("storageboats:textures/models/lit_furnace.png");
    private static final ResourceLocation SHULKER_TEXTURES = new ResourceLocation("textures/entity/shulker/shulker");
    RenderEntityItem itemRenderer;
    TileEntityBanner banner;
    public ModelBoat modelBoat = new ModelBoat();
    public ModelStorageBoat modelStorageBoat = new ModelStorageBoat();
    public ModelStorageBoat2 modelStorageBoat2 = new ModelStorageBoat2();

    public RenderStorageBoat(RenderManager renderManagerIn) {
        super(renderManagerIn);
        this.banner = new TileEntityBanner();
        this.field_76989_e = 0.5f;
    }

    public void doRender(EntityStorageBoat entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.renderLeash(entity, x, y, z, entityYaw, partialTicks);
        if (entity.getChestType() == "ironchest_crystalchest") {
            for (int i = 0; i < 27; ++i) {
                EntityItem item = new EntityItem(entity.field_70170_p, entity.field_70165_t - Math.cos(Math.toRadians(entity.field_70177_z)) * 0.25, entity.field_70163_u, entity.field_70161_v - Math.sin(Math.toRadians(entity.field_70177_z)) * 0.5, entity.getInventory().func_70301_a(i).func_77946_l());
                Minecraft.func_71410_x().func_175598_ae().func_188388_a((Entity)item, partialTicks, false);
            }
        }
        GlStateManager.func_179094_E();
        this.setupTranslation(x, y, z);
        this.setupRotation(entity, entityYaw, partialTicks);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        this.func_110776_a(this.getEntityTexture(entity, 0));
        this.modelStorageBoat.renderBoat(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (entity.hasChest()) {
            this.func_110776_a(this.getEntityTexture(entity, 1));
            if (entity.canOpenChest() && (entity.chestOpened() || entity.chestClosed())) {
                this.modelStorageBoat.renderChest(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            } else {
                this.modelStorageBoat2.renderChest(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
        }
        this.renderBanner(entity, partialTicks);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    private double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    public void renderLeash(EntityStorageBoat entityLivingIn, double x, double y, double z, float entityYaw, float partialTicks) {
        Entity entity = entityLivingIn.getLeashedToEntity();
        if (entity != null) {
            y -= (1.6 - (double)entityLivingIn.field_70131_O) * 0.8;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            double d0 = this.interpolateValue(entity.field_70126_B, entity.field_70177_z, partialTicks * 0.5f) * 0.01745329238474369;
            double d1 = this.interpolateValue(entity.field_70127_C, entity.field_70125_A, partialTicks * 0.5f) * 0.01745329238474369;
            double d2 = Math.cos(d0);
            double d3 = Math.sin(d0);
            double d4 = Math.sin(d1);
            double d18 = Math.cos(d0);
            double d19 = Math.sin(d0);
            if (entity instanceof EntityHanging) {
                d2 = 0.0;
                d3 = 0.0;
                d4 = -1.0;
            }
            double d5 = Math.cos(d1);
            double d6 = this.interpolateValue(entity.field_70169_q, entity.field_70165_t, partialTicks) - d2 * 0.7 - d3 * 0.5 * d5;
            double d7 = this.interpolateValue(entity.field_70167_r + (double)entity.func_70047_e() * 0.7, entity.field_70163_u + (double)entity.func_70047_e() * 0.7, partialTicks) - d4 * 0.5 + (entity instanceof EntityStorageBoat ? 1.0 : 0.5);
            double d8 = this.interpolateValue(entity.field_70166_s, entity.field_70161_v, partialTicks) - d3 * 0.7 + d2 * 0.5 * d5;
            double d9 = this.interpolateValue(entityLivingIn.field_70126_B, entityLivingIn.field_70126_B, partialTicks) * 0.01745329238474369 + 1.5707963267948966;
            d2 = Math.cos(d9) * (double)entityLivingIn.field_70130_N * 0.4;
            d3 = Math.sin(d9) * (double)entityLivingIn.field_70130_N * 0.4;
            double d10 = this.interpolateValue(entityLivingIn.field_70169_q, entityLivingIn.field_70165_t, partialTicks) + d2 - d18 * 0.7 - d19 * 1.2 * Math.cos(d1);
            double d11 = this.interpolateValue(entityLivingIn.field_70167_r, entityLivingIn.field_70163_u, partialTicks);
            double d12 = this.interpolateValue(entityLivingIn.field_70166_s, entityLivingIn.field_70161_v, partialTicks) + d3 - d19 * 0.7 + d18 * 1.2 * Math.cos(d1);
            if (!(entityLivingIn.getLeashedToEntity() instanceof EntityStorageBoat)) {
                d10 = this.interpolateValue(entityLivingIn.field_70169_q, entityLivingIn.field_70165_t, partialTicks) + d2;
                d11 = this.interpolateValue(entityLivingIn.field_70167_r, entityLivingIn.field_70163_u, partialTicks);
                d12 = this.interpolateValue(entityLivingIn.field_70166_s, entityLivingIn.field_70161_v, partialTicks) + d3;
            }
            x += d2;
            z += d3;
            double d13 = (float)(d6 - d10);
            double d14 = (float)(d7 - d11);
            double d15 = (float)(d8 - d12);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int j = 0; j <= 24; ++j) {
                float f = 0.5f;
                float f1 = 0.4f;
                float f2 = 0.3f;
                if (j % 2 == 0) {
                    f *= 0.7f;
                    f1 *= 0.7f;
                    f2 *= 0.7f;
                }
                float f3 = (float)j / 24.0f;
                vertexbuffer.func_181662_b(x + d13 * (double)f3 + 0.0, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f), z + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + d13 * (double)f3 + 0.025, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int k = 0; k <= 24; ++k) {
                float f4 = 0.5f;
                float f5 = 0.4f;
                float f6 = 0.3f;
                if (k % 2 == 0) {
                    f4 *= 0.7f;
                    f5 *= 0.7f;
                    f6 *= 0.7f;
                }
                float f7 = (float)k / 24.0f;
                vertexbuffer.func_181662_b(x + d13 * (double)f7 + 0.0, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f7).func_181666_a(f4, f5, f6, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + d13 * (double)f7 + 0.025, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f), z + d15 * (double)f7 + 0.025).func_181666_a(f4, f5, f6, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179089_o();
        }
    }

    private void renderBanner(EntityStorageBoat entity, float partialTicks) {
        if (this.banner == null || entity.getBanner() == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)(entity.hasChest() ? 0.0f : 1.0f));
        GlStateManager.func_179137_b((double)-0.5, (double)(entity.getBannerPos() == 1 ? -0.15 : (double)0.15f), (double)(entity.getBannerPos() == 0 ? 0.45 : (entity.getBannerPos() == 1 ? -0.5 : (double)-1.45f)));
        this.banner.func_175112_a(entity.getBanner(), false);
        TileEntityRendererDispatcher.field_147556_a.func_192855_a((TileEntity)this.banner, 0.0, 0.0, 0.0, partialTicks, 0.0f);
        GlStateManager.func_179121_F();
    }

    public void setupRotation(EntityStorageBoat entity, float angle, float p_188311_3_) {
        GlStateManager.func_179114_b((float)(180.0f - angle), (float)0.0f, (float)1.0f, (float)0.0f);
        float f = (float)entity.func_70268_h() - p_188311_3_;
        float f1 = entity.func_70271_g() - p_188311_3_;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entity.func_70267_i()), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    public void setupTranslation(double p_188309_1_, double p_188309_3_, double p_188309_5_) {
        GlStateManager.func_179109_b((float)((float)p_188309_1_), (float)((float)p_188309_3_ + 0.375f), (float)((float)p_188309_5_));
    }

    protected ResourceLocation getEntityTexture(EntityStorageBoat entity, int i) {
        if (i == 0) {
            return BOAT_TEXTURES[entity.func_184453_r().func_184982_b()];
        }
        if (i == 1) {
            String chestType = entity.getChestType();
            if (chestType.toLowerCase().equals("minecraft") || chestType.toLowerCase() == "tinyChest") {
                return CHEST_TEXTURES;
            }
            if (chestType.toLowerCase().equals("minecraft_enderchest")) {
                return ENDER_CHEST_TEXTURES;
            }
            if (chestType.toLowerCase().equals("furnace")) {
                return entity.getFuel() > 0 ? LIT_FURNACE_TEXTURES : FURNACE_TEXTURES;
            }
            if (chestType.toLowerCase().equals("hopper")) {
                return HOPPER_TEXTURES;
            }
            if (chestType.toLowerCase().startsWith("shulker")) {
                String colour = chestType.toLowerCase().substring("shulker".length(), chestType.length());
                return new ResourceLocation(SHULKER_TEXTURES.func_110623_a() + "_" + colour + ".png");
            }
            if (chestType.toLowerCase().startsWith("quark")) {
                String chestName = chestType.toLowerCase().substring("quark_".length(), chestType.length());
                return new ResourceLocation("quark:textures/blocks/chests/" + chestName + ".png");
            }
            if (chestType.toLowerCase().startsWith("ironchest")) {
                String chestName = chestType.toLowerCase().substring("ironchest_".length(), chestType.length());
                return new ResourceLocation("ironchest:textures/model/chest/" + chestName + ".png");
            }
            return CHEST_TEXTURES;
        }
        return BOAT_TEXTURES[entity.func_184453_r().func_184982_b()];
    }

    public boolean func_188295_H_() {
        return true;
    }

    public void renderMultipass(EntityStorageBoat entity, double xPos, double yPos, double zPos, float angle, float f) {
        GL11.glPushMatrix();
        this.setupTranslation(xPos, yPos, zPos);
        this.setupRotation(entity, angle, f);
        this.modelBoat.func_187054_b((Entity)entity, f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    protected ResourceLocation getEntityTexture(EntityStorageBoat entity) {
        return null;
    }
}

