/*
 * Decompiled with CFR 0.152.
 */
package com.mawnt.storageboats.event;

import com.mawnt.storageboats.StorageBoatsMod;
import com.mawnt.storageboats.entity.EntityStorageBoat;
import com.mawnt.storageboats.event.ConfigurationHandler;
import com.mawnt.storageboats.gui.StorageBoatGuiHandler;
import com.mawnt.storageboats.proxy.BannerToClient;
import com.mawnt.storageboats.proxy.ChestInventoryToClient;
import com.mawnt.storageboats.proxy.CommonProxy;
import com.mawnt.storageboats.proxy.FurnaceInventoryToClient;
import com.mawnt.storageboats.proxy.LeadToClient;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="storageboats")
public class StorageEventHandler {
    private static boolean inBoat;
    private static EntityStorageBoat entityStorageBoat;

    public static void preInit() {
    }

    public static void setEntityStorageBoat(EntityStorageBoat entity) {
        entityStorageBoat = entity;
    }

    public static void setInBoat(boolean b) {
        inBoat = b;
    }

    public static EntityStorageBoat getEntityStorageBoat() {
        return entityStorageBoat;
    }

    public static boolean isInBoat() {
        return inBoat;
    }

    @SubscribeEvent
    public void openGUI(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiInventory && inBoat) {
            event.setCanceled(true);
            if (entityStorageBoat != null) {
                entityStorageBoat.openInventory(null);
                return;
            }
        } else if (event.getGui() == null && entityStorageBoat != null && entityStorageBoat.chestOpened()) {
            entityStorageBoat.closeChest();
            CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new ChestInventoryToClient(entityStorageBoat.func_145782_y(), -2, 0, 0, 0, 0));
        }
    }

    @SubscribeEvent
    public void onConfigurationChangeEvent(ConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("storageboats")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onUpdate(TickEvent.WorldTickEvent event) {
        List entityList;
        if (entityStorageBoat == null) {
            entityStorageBoat = new EntityStorageBoat(event.world);
        }
        if ((entityList = event.world.func_72910_y()) != null) {
            for (int i = 0; i < entityList.size(); ++i) {
                Entity boat;
                if (((Entity)entityList.get(i)).getClass().getSuperclass() != EntityBoat.class && !(entityList.get(i) instanceof EntityBoat) || !(boat = (Entity)entityList.get(i)).func_70090_H() || event.world.func_180495_p(boat.func_180425_c()).func_185904_a() != Material.field_151586_h || this.getUnderwaterStatus(event.world, boat) != EntityBoat.Status.UNDER_FLOWING_WATER) continue;
                boat.field_70181_x += 0.5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityBoat.Status getUnderwaterStatus(World world, Entity boat) {
        AxisAlignedBB axisalignedbb = boat.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.25;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = true;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        EntityBoat.Status entityboat$status;
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() != Material.field_151586_h || !(d0 < (double)BlockLiquid.func_190972_g((IBlockState)iblockstate, (IBlockAccess)world, (BlockPos)blockpos$pooledmutableblockpos))) continue;
                        EntityBoat.Status status = entityboat$status = EntityBoat.Status.UNDER_FLOWING_WATER;
                        return status;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag ? EntityBoat.Status.UNDER_WATER : null;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        if (event.getWorld().func_180495_p(pos).func_177230_c() instanceof BlockFence) {
            EntityLeashKnot entityleashknot = EntityLeashKnot.func_174863_b((World)event.getWorld(), (BlockPos)pos);
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            for (EntityStorageBoat entity : world.func_72872_a(EntityStorageBoat.class, new AxisAlignedBB((double)i - 7.0, (double)j - 7.0, (double)k - 7.0, (double)i + 7.0, (double)j + 7.0, (double)k + 7.0))) {
                if (entity.getLeashed() && entity.getLeashedToEntity() == player) {
                    if (entityleashknot != null) continue;
                    entityleashknot = EntityLeashKnot.func_174862_a((World)world, (BlockPos)pos);
                    entity.setLeashedToEntity((Entity)entityleashknot, true);
                    if (event.getWorld().field_72995_K) break;
                    CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new LeadToClient(entity.func_145782_y(), entityleashknot.func_145782_y()));
                    break;
                }
                if (!entity.getLeashed() || !(entity.getLeashedToEntity() instanceof EntityLeashKnot) || !entity.getLeashedToEntity().func_180425_c().func_177977_b().equals((Object)event.getPos())) continue;
                if (entityleashknot != null) {
                    entityleashknot.func_70106_y();
                }
                entity.clearLeashed2(true, !player.field_71075_bZ.field_75098_d);
                if (event.getWorld().field_72995_K) continue;
                CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new LeadToClient(entity.func_145782_y(), -1));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        block192: {
            block196: {
                block195: {
                    block194: {
                        block193: {
                            block191: {
                                if (!(event.getTarget() instanceof EntityBoat) || !event.getEntityPlayer().func_70093_af()) break block191;
                                if (event.getTarget() instanceof EntityStorageBoat) {
                                    EntityStorageBoat target;
                                    EntityPlayer player = event.getEntityPlayer();
                                    entityStorageBoat = target = (EntityStorageBoat)event.getTarget();
                                    StorageBoatGuiHandler.boat = target.func_145782_y();
                                    ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                                    if (stack == null || stack == ItemStack.field_190927_a) {
                                        if (target.getBanner() != null && StorageBoatsMod.banners) {
                                            int i = target.getBannerPos();
                                            if (++i > 2) {
                                                i = 0;
                                            }
                                            target.setBanner(target.getBanner(), i);
                                            if (!event.getWorld().field_72995_K) {
                                                CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new BannerToClient(target.func_145782_y(), target.getBannerPos(), target.getBanner().func_77952_i()));
                                            }
                                        } else if (event.getHand() == EnumHand.MAIN_HAND) {
                                            if (!target.getChestType().equals("furnace")) {
                                                target.openInventory(player);
                                            } else {
                                                event.getEntityPlayer().openGui((Object)"storageboats", 0, event.getWorld(), (int)event.getTarget().field_70165_t, (int)event.getTarget().field_70163_u, (int)event.getTarget().field_70161_v);
                                            }
                                        }
                                    } else if (target.isFurnaceBoat() && !event.getWorld().field_72995_K && event.getHand() == EnumHand.MAIN_HAND) {
                                        if (stack.func_77973_b() == Items.field_151044_h) {
                                            target.setFuel(200, true, true);
                                            if (target.furnaceBoatInventory.func_70301_a(0) == null || target.furnaceBoatInventory.func_70301_a(0).func_190926_b()) {
                                                target.furnaceBoatInventory.func_70299_a(0, new ItemStack(Items.field_151044_h, 1, event.getItemStack().func_77952_i()));
                                            } else if (target.furnaceBoatInventory.func_70301_a(0).func_77973_b() == Items.field_151044_h) {
                                                target.furnaceBoatInventory.func_70301_a(0).func_190917_f(1);
                                            }
                                            if (!player.field_71075_bZ.field_75098_d) {
                                                stack.func_190920_e(stack.func_190916_E() - 1);
                                            }
                                            CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new FurnaceInventoryToClient(target.furnaceBoatInventory.func_70301_a(0).func_190916_E(), target.getFuel(), target.func_145782_y(), Item.func_150891_b((Item)target.furnaceBoatInventory.func_70301_a(0).func_77973_b())));
                                        } else if (stack.func_77973_b() == Items.field_151129_at) {
                                            target.setFuel(400, true, true);
                                            if (target.furnaceBoatInventory.func_70301_a(0) == null || target.furnaceBoatInventory.func_70301_a(0).func_190926_b()) {
                                                target.furnaceBoatInventory.func_70299_a(0, new ItemStack(Items.field_151133_ar));
                                            } else if (target.furnaceBoatInventory.func_70301_a(0).func_77973_b() == Items.field_151129_at || target.furnaceBoatInventory.func_70301_a(0).func_77973_b() == Items.field_151133_ar) {
                                                return;
                                            }
                                            if (!player.field_71075_bZ.field_75098_d) {
                                                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                                            }
                                            CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new FurnaceInventoryToClient(target.furnaceBoatInventory.func_70301_a(0).func_190916_E(), target.getFuel(), target.func_145782_y(), Item.func_150891_b((Item)target.furnaceBoatInventory.func_70301_a(0).func_77973_b())));
                                        }
                                    } else if (event.getTarget() instanceof EntityBoat && event.getItemStack().func_77973_b() == Items.field_179564_cE && StorageBoatsMod.banners) {
                                        event.getTarget().func_70106_y();
                                        EntityStorageBoat entityStorageBoat = new EntityStorageBoat(event.getWorld(), event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v);
                                        entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(((EntityBoat)event.getTarget()).func_184453_r().func_184982_b()));
                                        entityStorageBoat.field_70126_B = event.getTarget().field_70177_z;
                                        entityStorageBoat.field_70126_B = event.getTarget().field_70177_z;
                                        entityStorageBoat.field_70177_z = event.getTarget().field_70177_z;
                                        entityStorageBoat.setChestType(((EntityStorageBoat)event.getTarget()).getChestType());
                                        if (event.getHand() != EnumHand.MAIN_HAND) {
                                            return;
                                        }
                                        if (event.getWorld().field_72995_K) {
                                            return;
                                        }
                                        event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                        ItemStack copyStack = event.getItemStack().func_77946_l();
                                        event.getEntityPlayer().func_184609_a(event.getHand());
                                        entityStorageBoat.setBanner(copyStack, 0);
                                        CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new BannerToClient(entityStorageBoat.func_145782_y(), entityStorageBoat.getBannerPos(), entityStorageBoat.getBanner().func_77952_i()));
                                        if (!event.getWorld().field_72995_K) {
                                            event.setCanceled(true);
                                            if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                                                event.getItemStack().func_190918_g(1);
                                                if (event.getItemStack().func_190916_E() <= 0) {
                                                    event.getEntityPlayer().func_184611_a(event.getHand(), ItemStack.field_190927_a);
                                                }
                                            }
                                        }
                                    } else {
                                        double y;
                                        ItemStack currentItemStack = event.getItemStack();
                                        EntityStorageBoat boat = target;
                                        double d = y = boat.func_70090_H() ? 0.25 : 0.0;
                                        if (target.getChestType() != "noChest") {
                                            if (!event.getWorld().field_72995_K && event.getHand() == EnumHand.MAIN_HAND) {
                                                if (!target.getChestType().equals("furnace")) {
                                                    target.openInventory(player);
                                                } else if (!event.getWorld().field_72995_K) {
                                                    event.getEntityPlayer().openGui((Object)"storageboats", 0, event.getWorld(), (int)event.getTarget().field_70165_t, (int)event.getTarget().field_70163_u, (int)event.getTarget().field_70161_v);
                                                }
                                            }
                                            CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new ChestInventoryToClient(target.func_145782_y(), -1, 0, 0, 0, 0));
                                            return;
                                        }
                                        EntityStorageBoat entityStorageBoat = new EntityStorageBoat(player.func_130014_f_(), boat.field_70165_t, boat.field_70163_u + y, boat.field_70161_v);
                                        if (currentItemStack == null || currentItemStack.func_190926_b()) {
                                            return;
                                        }
                                        if (currentItemStack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)currentItemStack.func_77973_b()) != Blocks.field_150350_a) {
                                            if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) == Blocks.field_150486_ae) {
                                                boat.func_70106_y();
                                                entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70177_z = boat.field_70177_z;
                                                entityStorageBoat.setChestType("minecraft");
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                                if (event.getHand() != EnumHand.MAIN_HAND) {
                                                    return;
                                                }
                                                if (event.getWorld().field_72995_K) {
                                                    return;
                                                }
                                                event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                            } else if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) == Blocks.field_150477_bB) {
                                                boat.func_70106_y();
                                                entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70177_z = boat.field_70177_z;
                                                entityStorageBoat.setChestType("minecraft_enderchest");
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                                if (event.getHand() != EnumHand.MAIN_HAND) {
                                                    return;
                                                }
                                                if (event.getWorld().field_72995_K) {
                                                    return;
                                                }
                                                event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                            } else if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) == Blocks.field_150460_al) {
                                                boat.func_70106_y();
                                                entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70177_z = boat.field_70177_z;
                                                entityStorageBoat.setChestType("furnace");
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                                if (event.getHand() != EnumHand.MAIN_HAND) {
                                                    return;
                                                }
                                                if (event.getWorld().field_72995_K) {
                                                    return;
                                                }
                                                event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                            } else if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) instanceof BlockShulkerBox) {
                                                boat.func_70106_y();
                                                String colour = ((BlockShulkerBox)Block.func_149634_a((Item)currentItemStack.func_77973_b())).func_190956_e().func_176610_l();
                                                entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70177_z = boat.field_70177_z;
                                                entityStorageBoat.setChestType("shulker" + colour);
                                                if (currentItemStack.func_77942_o()) {
                                                    NBTTagCompound compound = (NBTTagCompound)currentItemStack.func_77978_p().func_74781_a("BlockEntityTag");
                                                    NBTTagList items = compound.func_150295_c("Items", 10);
                                                    for (int i = 0; i < items.func_74745_c(); ++i) {
                                                        ItemStack itemStack = new ItemStack(items.func_150305_b(i));
                                                        entityStorageBoat.getInventory().func_70299_a(i, itemStack);
                                                    }
                                                }
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                                if (event.getHand() != EnumHand.MAIN_HAND) {
                                                    return;
                                                }
                                                if (event.getWorld().field_72995_K) {
                                                    return;
                                                }
                                                event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                            } else if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) instanceof BlockHopper) {
                                                boat.func_70106_y();
                                                entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                entityStorageBoat.field_70177_z = boat.field_70177_z;
                                                entityStorageBoat.setChestType("hopper");
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                                if (event.getHand() != EnumHand.MAIN_HAND) {
                                                    return;
                                                }
                                                if (event.getWorld().field_72995_K) {
                                                    return;
                                                }
                                                event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    currentItemStack.func_190917_f(-1);
                                                }
                                            } else {
                                                entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                                String chestItemName = currentItemStack.func_77977_a();
                                                if (chestItemName.contains("ironchest")) {
                                                    boat.func_70106_y();
                                                    entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                                    entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                    entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                    entityStorageBoat.field_70177_z = boat.field_70177_z;
                                                    int metadata = currentItemStack.func_77952_i();
                                                    String chestName = "";
                                                    if (metadata == 0) {
                                                        chestName = "ironchest_iron_chest";
                                                    } else if (metadata == 1) {
                                                        chestName = "ironchest_gold_chest";
                                                    } else if (metadata == 2) {
                                                        chestName = "ironchest_diamond_chest";
                                                    } else if (metadata == 3) {
                                                        chestName = "ironchest_copper_chest";
                                                    } else if (metadata == 4) {
                                                        chestName = "ironchest_silver_chest";
                                                    } else if (metadata == 5) {
                                                        chestName = "ironchest_crystal_chest";
                                                    } else if (metadata == 6) {
                                                        chestName = "ironchest_obsidian_chest";
                                                    } else if (metadata == 7) {
                                                        chestName = "ironchest_dirt_chest";
                                                    }
                                                    entityStorageBoat.setChestType(chestName);
                                                    if (event.getHand() != EnumHand.MAIN_HAND) {
                                                        return;
                                                    }
                                                    if (event.getWorld().field_72995_K) {
                                                        return;
                                                    }
                                                    event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                                    if (!player.field_71075_bZ.field_75098_d) {
                                                        currentItemStack.func_190917_f(-1);
                                                    }
                                                } else if (chestItemName.contains("custom_chest")) {
                                                    boat.func_70106_y();
                                                    entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                                    entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                    entityStorageBoat.field_70126_B = boat.field_70177_z;
                                                    entityStorageBoat.field_70177_z = boat.field_70177_z;
                                                    int metadata = currentItemStack.func_77952_i();
                                                    String chestName = "";
                                                    if (metadata == 0) {
                                                        chestName = "quark_spruce";
                                                    } else if (metadata == 1) {
                                                        chestName = "quark_birch";
                                                    } else if (metadata == 2) {
                                                        chestName = "quark_jungle";
                                                    } else if (metadata == 3) {
                                                        chestName = "quark_acacia";
                                                    } else if (metadata == 4) {
                                                        chestName = "quark_dark_oak";
                                                    }
                                                    entityStorageBoat.setChestType(chestName);
                                                    if (event.getHand() != EnumHand.MAIN_HAND) {
                                                        return;
                                                    }
                                                    if (event.getWorld().field_72995_K) {
                                                        return;
                                                    }
                                                    event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                                    if (!player.field_71075_bZ.field_75098_d) {
                                                        currentItemStack.func_190917_f(-1);
                                                    }
                                                } else if (chestItemName.toLowerCase().contains("tinychest")) {
                                                    boat.func_70106_y();
                                                    entityStorageBoat.setChestType("tinyChest");
                                                    if (event.getHand() != EnumHand.MAIN_HAND) {
                                                        return;
                                                    }
                                                    if (event.getWorld().field_72995_K) {
                                                        return;
                                                    }
                                                    event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                                    if (!player.field_71075_bZ.field_75098_d) {
                                                        currentItemStack.func_190917_f(-1);
                                                    }
                                                } else {
                                                    entityStorageBoat.setChestType("minecraft");
                                                }
                                            }
                                        }
                                    }
                                    event.setCanceled(true);
                                    return;
                                }
                                EntityPlayer player = event.getEntityPlayer();
                                EntityBoat boat = (EntityBoat)event.getTarget();
                                double y = boat.func_70090_H() ? 0.25 : 0.0;
                                EntityStorageBoat entityStorageBoat = new EntityStorageBoat(player.func_130014_f_(), boat.field_70165_t, boat.field_70163_u + y, boat.field_70161_v);
                                ItemStack currentItemStack = player.field_71071_by.func_70448_g();
                                if (currentItemStack == null || currentItemStack.func_190926_b()) {
                                    return;
                                }
                                if (currentItemStack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)currentItemStack.func_77973_b()) != Blocks.field_150350_a) {
                                    if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) == Blocks.field_150486_ae) {
                                        boat.func_70106_y();
                                        entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70177_z = boat.field_70177_z;
                                        entityStorageBoat.setChestType("minecraft");
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                        if (event.getHand() != EnumHand.MAIN_HAND) {
                                            return;
                                        }
                                        if (event.getWorld().field_72995_K) {
                                            return;
                                        }
                                        event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                    } else if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) == Blocks.field_150477_bB) {
                                        boat.func_70106_y();
                                        entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70177_z = boat.field_70177_z;
                                        entityStorageBoat.setChestType("minecraft_enderchest");
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                        if (event.getHand() != EnumHand.MAIN_HAND) {
                                            return;
                                        }
                                        if (event.getWorld().field_72995_K) {
                                            return;
                                        }
                                        event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                    } else if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) == Blocks.field_150460_al) {
                                        boat.func_70106_y();
                                        entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70177_z = boat.field_70177_z;
                                        entityStorageBoat.setChestType("furnace");
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                        if (event.getHand() != EnumHand.MAIN_HAND) {
                                            return;
                                        }
                                        if (event.getWorld().field_72995_K) {
                                            return;
                                        }
                                        event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                    } else if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) instanceof BlockShulkerBox) {
                                        boat.func_70106_y();
                                        String colour = ((BlockShulkerBox)Block.func_149634_a((Item)currentItemStack.func_77973_b())).func_190956_e().func_176610_l();
                                        entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70177_z = boat.field_70177_z;
                                        entityStorageBoat.setChestType("shulker" + colour);
                                        if (currentItemStack.func_77942_o()) {
                                            NBTTagCompound compound = (NBTTagCompound)currentItemStack.func_77978_p().func_74781_a("BlockEntityTag");
                                            NBTTagList items = compound.func_150295_c("Items", 10);
                                            for (int i = 0; i < items.func_74745_c(); ++i) {
                                                ItemStack itemStack = new ItemStack(items.func_150305_b(i));
                                                entityStorageBoat.getInventory().func_70299_a(i, itemStack);
                                            }
                                        }
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                        if (event.getHand() != EnumHand.MAIN_HAND) {
                                            return;
                                        }
                                        if (event.getWorld().field_72995_K) {
                                            return;
                                        }
                                        event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                    } else if (Block.func_149634_a((Item)currentItemStack.func_77973_b()) instanceof BlockHopper) {
                                        boat.func_70106_y();
                                        entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70126_B = boat.field_70177_z;
                                        entityStorageBoat.field_70177_z = boat.field_70177_z;
                                        entityStorageBoat.setChestType("hopper");
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                        if (event.getHand() != EnumHand.MAIN_HAND) {
                                            return;
                                        }
                                        if (event.getWorld().field_72995_K) {
                                            return;
                                        }
                                        event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            currentItemStack.func_190917_f(-1);
                                        }
                                    } else {
                                        entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                        String chestItemName = currentItemStack.func_77977_a();
                                        if (chestItemName.contains("ironchest")) {
                                            boat.func_70106_y();
                                            entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                            entityStorageBoat.field_70126_B = boat.field_70177_z;
                                            entityStorageBoat.field_70126_B = boat.field_70177_z;
                                            entityStorageBoat.field_70177_z = boat.field_70177_z;
                                            int metadata = currentItemStack.func_77952_i();
                                            String chestName = "";
                                            if (metadata == 0) {
                                                chestName = "ironchest_iron_chest";
                                            } else if (metadata == 1) {
                                                chestName = "ironchest_gold_chest";
                                            } else if (metadata == 2) {
                                                chestName = "ironchest_diamond_chest";
                                            } else if (metadata == 3) {
                                                chestName = "ironchest_copper_chest";
                                            } else if (metadata == 4) {
                                                chestName = "ironchest_silver_chest";
                                            } else if (metadata == 5) {
                                                chestName = "ironchest_crystal_chest";
                                            } else if (metadata == 6) {
                                                chestName = "ironchest_obsidian_chest";
                                            } else if (metadata == 7) {
                                                chestName = "ironchest_dirt_chest";
                                            }
                                            entityStorageBoat.setChestType(chestName);
                                            if (event.getHand() != EnumHand.MAIN_HAND) {
                                                return;
                                            }
                                            if (event.getWorld().field_72995_K) {
                                                return;
                                            }
                                            event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                            if (!player.field_71075_bZ.field_75098_d) {
                                                currentItemStack.func_190917_f(-1);
                                            }
                                        } else if (chestItemName.contains("custom_chest")) {
                                            boat.func_70106_y();
                                            entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(boat.func_184453_r().func_184982_b()));
                                            entityStorageBoat.field_70126_B = boat.field_70177_z;
                                            entityStorageBoat.field_70126_B = boat.field_70177_z;
                                            entityStorageBoat.field_70177_z = boat.field_70177_z;
                                            int metadata = currentItemStack.func_77952_i();
                                            String chestName = "";
                                            if (metadata == 0) {
                                                chestName = "quark_spruce";
                                            } else if (metadata == 1) {
                                                chestName = "quark_birch";
                                            } else if (metadata == 2) {
                                                chestName = "quark_jungle";
                                            } else if (metadata == 3) {
                                                chestName = "quark_acacia";
                                            } else if (metadata == 4) {
                                                chestName = "quark_dark_oak";
                                            }
                                            entityStorageBoat.setChestType(chestName);
                                            if (event.getHand() != EnumHand.MAIN_HAND) {
                                                return;
                                            }
                                            if (event.getWorld().field_72995_K) {
                                                return;
                                            }
                                            event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                            if (!player.field_71075_bZ.field_75098_d) {
                                                currentItemStack.func_190917_f(-1);
                                            }
                                        } else if (chestItemName.toLowerCase().contains("tinychest")) {
                                            boat.func_70106_y();
                                            entityStorageBoat.setChestType("tinyChest");
                                            if (event.getHand() != EnumHand.MAIN_HAND) {
                                                return;
                                            }
                                            if (event.getWorld().field_72995_K) {
                                                return;
                                            }
                                            event.getWorld().func_72838_d((Entity)entityStorageBoat);
                                            if (!player.field_71075_bZ.field_75098_d) {
                                                currentItemStack.func_190917_f(-1);
                                            }
                                        } else {
                                            entityStorageBoat.setChestType("minecraft");
                                        }
                                    }
                                }
                                break block192;
                            }
                            if (!(event.getTarget() instanceof EntityStorageBoat)) break block193;
                            EntityPlayer player = event.getEntityPlayer();
                            EntityStorageBoat target = (EntityStorageBoat)event.getTarget();
                            ItemStack stack = player.func_184586_b(event.getHand());
                            if (player.func_70093_af()) break block192;
                            if (stack == null || stack.func_190926_b()) {
                                return;
                            }
                            if (stack.func_77973_b() != Items.field_179564_cE || !StorageBoatsMod.banners) break block192;
                            ItemStack copyStack = stack.func_77946_l();
                            player.func_184609_a(event.getHand());
                            target.setBanner(copyStack, 2);
                            if (event.getWorld().field_72995_K) break block192;
                            event.setCanceled(true);
                            if (player.field_71075_bZ.field_75098_d) break block192;
                            stack.func_190918_g(1);
                            if (stack.func_190916_E() > 0) break block192;
                            player.func_184611_a(event.getHand(), ItemStack.field_190927_a);
                            break block192;
                        }
                        if (!(event.getTarget() instanceof EntityBoat) || !event.getEntityPlayer().func_184218_aH() || !(event.getEntityPlayer().func_184187_bx() instanceof EntityStorageBoat)) break block194;
                        inBoat = false;
                        entityStorageBoat = null;
                        break block192;
                    }
                    if (!(event.getTarget() instanceof EntityBoat) || event.getItemStack().func_77973_b() != Items.field_151058_ca) break block195;
                    event.getTarget().func_70106_y();
                    EntityStorageBoat entityStorageBoat = new EntityStorageBoat(event.getWorld(), event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v);
                    entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(((EntityBoat)event.getTarget()).func_184453_r().func_184982_b()));
                    entityStorageBoat.field_70126_B = event.getTarget().field_70177_z;
                    entityStorageBoat.field_70126_B = event.getTarget().field_70177_z;
                    entityStorageBoat.field_70177_z = event.getTarget().field_70177_z;
                    entityStorageBoat.setChestType("noChest");
                    if (event.getHand() != EnumHand.MAIN_HAND) {
                        return;
                    }
                    if (event.getWorld().field_72995_K) {
                        return;
                    }
                    event.getWorld().func_72838_d((Entity)entityStorageBoat);
                    entityStorageBoat.setLeashedToEntity((Entity)event.getEntityPlayer(), true);
                    if (!event.getWorld().field_72995_K) {
                        CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new LeadToClient(entityStorageBoat.func_145782_y(), event.getEntityPlayer().func_145782_y()));
                    }
                    break block192;
                }
                if (!(event.getTarget() instanceof EntityBoat) || event.getItemStack().func_77973_b() != Items.field_179564_cE || !StorageBoatsMod.banners) break block196;
                event.getTarget().func_70106_y();
                EntityStorageBoat entityStorageBoat = new EntityStorageBoat(event.getWorld(), event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v);
                entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(((EntityBoat)event.getTarget()).func_184453_r().func_184982_b()));
                entityStorageBoat.field_70126_B = event.getTarget().field_70177_z;
                entityStorageBoat.field_70126_B = event.getTarget().field_70177_z;
                entityStorageBoat.field_70177_z = event.getTarget().field_70177_z;
                entityStorageBoat.setChestType("noChest");
                if (event.getHand() != EnumHand.MAIN_HAND) {
                    return;
                }
                if (event.getWorld().field_72995_K) {
                    return;
                }
                event.getWorld().func_72838_d((Entity)entityStorageBoat);
                ItemStack copyStack = event.getItemStack().func_77946_l();
                event.getEntityPlayer().func_184609_a(event.getHand());
                entityStorageBoat.setBanner(copyStack, 0);
                CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new BannerToClient(entityStorageBoat.func_145782_y(), entityStorageBoat.getBannerPos(), entityStorageBoat.getBanner().func_77952_i()));
                if (event.getWorld().field_72995_K) break block192;
                event.setCanceled(true);
                if (event.getEntityPlayer().field_71075_bZ.field_75098_d) break block192;
                event.getItemStack().func_190918_g(1);
                if (event.getItemStack().func_190916_E() > 0) break block192;
                event.getEntityPlayer().func_184611_a(event.getHand(), ItemStack.field_190927_a);
                break block192;
            }
            if (event.getTarget() instanceof EntityBoat) {
                for (EntityStorageBoat entity : event.getWorld().func_72872_a(EntityStorageBoat.class, new AxisAlignedBB(event.getTarget().field_70165_t - 7.0, event.getTarget().field_70163_u - 7.0, event.getTarget().field_70161_v - 7.0, event.getTarget().field_70165_t + 7.0, event.getTarget().field_70163_u + 7.0, event.getTarget().field_70161_v + 7.0))) {
                    if (!entity.getLeashed() || entity.getLeashedToEntity() != event.getEntityPlayer()) continue;
                    event.getTarget().func_70106_y();
                    EntityStorageBoat entityStorageBoat = new EntityStorageBoat(event.getWorld(), event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v);
                    entityStorageBoat.setBoatType(EntityStorageBoat.Type.byId(((EntityBoat)event.getTarget()).func_184453_r().func_184982_b()));
                    entityStorageBoat.field_70126_B = event.getTarget().field_70177_z;
                    entityStorageBoat.field_70126_B = event.getTarget().field_70177_z;
                    entityStorageBoat.field_70177_z = event.getTarget().field_70177_z;
                    entityStorageBoat.setChestType("noChest");
                    if (event.getHand() != EnumHand.MAIN_HAND) {
                        return;
                    }
                    if (event.getWorld().field_72995_K) {
                        return;
                    }
                    event.getWorld().func_72838_d((Entity)entityStorageBoat);
                    entity.setLeashedToEntity((Entity)entityStorageBoat, true);
                    if (event.getWorld().field_72995_K) continue;
                    CommonProxy.simpleNetworkWrapper.sendToAll((IMessage)new LeadToClient(entity.func_145782_y(), entityStorageBoat.func_145782_y()));
                }
            }
        }
        event.setResult(Event.Result.DEFAULT);
    }
}

