/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz;

import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;
import vapourdrive.hammerz.Hammerz;
import vapourdrive.hammerz.items.HZ_Items;
import vapourdrive.hammerz.items.hammer.HammerInfoHandler;
import vapourdrive.hammerz.items.hammer.HammerType;
import vapourdrive.hammerz.utils.RandomUtils;

@Optional.Interface(modid="RotaryCraft", iface="Reika.RotaryCraft.API.RecipeInterface", striprefs=true)
public class Recipes {
    public static HashMap<String, IRecipe> recipes = new HashMap();

    public static void init() {
        Hammerz.log.log(Level.INFO, "Starting hammerz recipe registering");
        Recipes.registerStorageBlockRecipe("ingotVoid", "blockVoid");
        Recipes.registerHammerRecipe("stickWood", "wood", "logWood");
        Recipes.registerHammerRecipe("stickWood", "stone", "stone");
        Recipes.registerHammerRecipe("stickWood", "iron", "blockIron");
        Recipes.registerHammerRecipe("stickWood", "gold", "blockGold");
        Recipes.registerHammerRecipe("stickWood", "diamond", "blockDiamond");
        Recipes.registerHammerRecipe("stickWood", "copper", "blockCopper");
        Recipes.registerHammerRecipe("stickWood", "tin", "blockTin");
        Recipes.registerHammerRecipe("stickWood", "silver", "blockSilver");
        Recipes.registerHammerRecipe("stickWood", "lead", "blockLead");
        Recipes.registerHammerRecipe("stickWood", "nickel", "blockNickel");
        Recipes.registerHammerRecipe("stickWood", "electrum", "blockElectrum");
        Recipes.registerHammerRecipe("stickWood", "invar", "blockInvar");
        Recipes.registerHammerRecipe("stickWood", "bronze", "blockBronze");
        Recipes.registerHammerRecipe("stickWood", "platinum", "blockPlatinum");
        Recipes.registerHammerRecipe("stickWood", "steel", "blockSteel");
        Recipes.registerHammerRecipe("livingwoodTwig", "manasteel", "blockManasteel");
        Recipes.registerHammerRecipe("dreamwoodTwig", "b_elementium", "blockElvenElementium");
    }

    public static void registerStorageBlockRecipe(String ingot, String block) {
        List blocks = OreDictionary.getOres((String)block);
        for (ItemStack stack : blocks) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stack, new Object[]{"iii", "iii", "iii", Character.valueOf('i'), ingot}));
        }
        List ingots = OreDictionary.getOres((String)ingot);
        for (ItemStack stack : ingots) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(stack.func_77973_b(), 9, stack.func_77952_i()), new Object[]{block}));
        }
    }

    public static void registerHammerRecipe(String stick, String material, String OreDict) {
        HammerType type = HammerInfoHandler.getHammerType(material);
        if (type != null) {
            ItemStack hammer = new ItemStack(HZ_Items.ItemHammer);
            NBTTagCompound tagCompound = RandomUtils.getNBT(hammer);
            tagCompound.func_74778_a("Hammerz.HammerType", type.getName());
            Hammerz.log.log(Level.INFO, "Registering " + material + " hammer out of " + stick + " handle material and " + OreDict + " body material");
            ShapedOreRecipe recipe = new ShapedOreRecipe(hammer.func_77946_l(), new Object[]{"bbb", " s ", " s ", Character.valueOf('s'), stick, Character.valueOf('b'), OreDict});
            GameRegistry.addRecipe((IRecipe)recipe);
            recipes.put(material, (IRecipe)recipe);
        }
    }

    public static void registerRotaryCraftRecipe() {
    }
}

