/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.config;

import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import vapourdrive.hammerz.Reference;
import vapourdrive.hammerz.config.ConfigOptions;

public class HammerzConfig {
    public static Configuration config;
    public static String CatEnable;
    public static String CatHammer;
    public static String CatTextures;
    public static String CatRandom;
    public static boolean[] enabledEnderIOHammers;
    public static boolean[] enabledBotaniaHammers;
    public static boolean[] enabledRotaryCraftHammers;
    public static boolean[] enabledThaumcrafHammers;
    public static boolean[] enabledForbiddenMagicHammers;
    public static ArrayList enabledOreDictHammersArrayList;
    public static String enabledOreDictHammersComment;
    public static String unityTextureComment;
    public static String enableToolInfoComment;
    public static String enableOreDictRegistryComment;
    public static String enableDurabilityInfoComment;
    public static String enableShiftMineComment;
    public static String enableRocSilkTouchComment;
    public static String durabilityMultiplierComment;
    public static String efficiencyMultiplierComment;
    public static String energyUseComment;

    public static void preInit(File hammerzCFG) {
        config = new Configuration(hammerzCFG);
        config.load();
        ConfigOptions.DurabilityMultiplier = config.getFloat("Hammer Durability Multiplier", CatHammer, 6.0f, 1.0f, 9.0f, durabilityMultiplierComment);
        config.save();
    }

    public static void init(File hammerzCFG) {
        config = new Configuration(hammerzCFG);
        config.load();
        boolean[] enabledOreDictHammers = HammerzConfig.generateArray();
        ConfigOptions.OreDictHammerEnabling = config.get(CatEnable, "OreDictHammerEnabling", enabledOreDictHammers, enabledOreDictHammersComment, true, enabledOreDictHammers.length).getBooleanList();
        ConfigOptions.UseUnityTextures = config.getBoolean("Use Unity Style Textures", CatTextures, true, unityTextureComment);
        if (ConfigOptions.UseUnityTextures) {
            Reference.ResourcePath = Reference.ResourcePath + "unity/";
        }
        ConfigOptions.AddToolInfo = config.getBoolean("Enable Tool Info Addition", CatRandom, false, enableToolInfoComment);
        ConfigOptions.AddOreDictEntries = config.getBoolean("Enable OreDictionary Entry Addition", CatRandom, false, enableOreDictRegistryComment);
        ConfigOptions.AddDurabilityInfo = config.getBoolean("Enable Hammer Durability Info Addition", CatRandom, false, enableDurabilityInfoComment);
        ConfigOptions.CanShiftMine = config.getBoolean("Enable Hammer Shift Mine", CatEnable, true, enableShiftMineComment);
        ConfigOptions.RotaryCraftSilkTouch = config.getBoolean("Enable RotaryCraft Hammer Silk Touch", CatEnable, true, enableRocSilkTouchComment);
        ConfigOptions.EfficiencyMultiplier = config.getFloat("Hammer Efficiency Multiplier", CatHammer, 0.25f, 0.05f, 1.0f, efficiencyMultiplierComment);
        ConfigOptions.HammerEnergyUse = config.getInt("Hammer Energy Consumption", CatHammer, 750, 100, 10000, energyUseComment);
        config.save();
    }

    public static boolean[] generateArray() {
        boolean[] hammers = new boolean[enabledOreDictHammersArrayList.size()];
        for (int i = 0; i < enabledOreDictHammersArrayList.size(); ++i) {
            if (enabledOreDictHammersArrayList.get(i) == null) continue;
            hammers[i] = (Boolean)enabledOreDictHammersArrayList.get(i);
        }
        return hammers;
    }

    static {
        CatEnable = "Feature Enabling";
        CatHammer = "Hammer Values";
        CatTextures = "Texture Set";
        CatRandom = "Random features";
        enabledEnderIOHammers = new boolean[]{true};
        enabledBotaniaHammers = new boolean[]{true, true};
        enabledRotaryCraftHammers = new boolean[]{true, true};
        enabledThaumcrafHammers = new boolean[]{true, true, true};
        enabledForbiddenMagicHammers = new boolean[]{true};
        enabledOreDictHammersArrayList = new ArrayList();
        enabledOreDictHammersComment = "Enabled OreDictionary Hammers: ";
        unityTextureComment = "Use unified texture set vs mod-specific look";
        enableToolInfoComment = "Adds information about tool's materials to their tooltips";
        enableOreDictRegistryComment = "Adds information about itemstack's OreDictionary entries to their tooltips";
        enableDurabilityInfoComment = "Adds information about hammer's current damage their tooltips";
        enableShiftMineComment = "Allows the hammer to mine a single block while sneaking";
        enableRocSilkTouchComment = "RotaryCraft Hammer will have Silk Touch upon crafting";
        durabilityMultiplierComment = "Durability Multiplier for hammers from base toolset durability";
        efficiencyMultiplierComment = "Efficiency Multiplier for hammers from base toolset efficiency";
        energyUseComment = "Energy used that would be equivalent to one damage point";
    }
}

