/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vapourdrive.hammerz.items.Hammer;
import vapourdrive.hammerz.utils.RandomUtils;

public class ChameleonHammer
extends Hammer {
    public String PhaseKey = "Hammerz.phase";
    public String EnchantKey = "Hammerz.enchant";

    public ChameleonHammer(String Name) {
        super(Item.ToolMaterial.IRON, Name);
        this.setHarvestLevel("pickaxe", 4);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemstack, int renderpass) {
        if (renderpass != 1) {
            return 0xFFFFFF;
        }
        if (!itemstack.func_77942_o()) {
            return 0x980000;
        }
        byte phase = itemstack.func_77978_p().func_74771_c(this.PhaseKey);
        if (phase == 1) {
            return 4300;
        }
        if (phase == 2) {
            return 15063552;
        }
        return 0x980000;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    public void addExpandedInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        boolean flag = false;
        if (stack.func_77942_o()) {
            NBTTagCompound tags = RandomUtils.getNBT(stack);
            for (int j = 0; j <= 2; ++j) {
                NBTTagList nbttaglist = (NBTTagList)tags.func_74781_a(this.EnchantKey + j);
                if (nbttaglist == null) continue;
                flag = true;
                list.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"hammerz.keyword.phase") + " " + (j + 1));
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                    short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                    if (Enchantment.func_180306_c((int)short1) == null) continue;
                    list.add("    " + Enchantment.func_180306_c((int)short1).func_77316_c((int)short2));
                }
            }
        }
        if (flag) {
            list.add("");
        }
        super.addExpandedInfo(stack, player, list, useExtraInformation);
    }

    @Override
    public boolean func_82789_a(ItemStack stack, ItemStack stack2) {
        ItemStack shard = RandomUtils.getItemStackFromString("ForbiddenMagic", "NetherShard", 8);
        return stack2.func_77969_a(new ItemStack(shard.func_77973_b(), 8, 1)) && stack2.field_77994_a >= 8;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (player.func_70093_af() && itemstack.func_77942_o() && this.getMaxDamage(itemstack) - itemstack.func_77952_i() > 5) {
            NBTTagList enchants;
            NBTTagCompound tags = itemstack.func_77978_p();
            byte phase = tags.func_74771_c(this.PhaseKey);
            if (tags.func_74764_b("ench")) {
                enchants = itemstack.func_77986_q();
                tags.func_74782_a(this.EnchantKey + phase, (NBTBase)enchants);
            } else {
                tags.func_82580_o(this.EnchantKey + phase);
            }
            phase = (byte)(phase + 1);
            if (phase > 2) {
                phase = 0;
            }
            tags.func_74774_a(this.PhaseKey, phase);
            if (tags.func_74764_b(this.EnchantKey + phase)) {
                enchants = (NBTTagList)tags.func_74781_a(this.EnchantKey + phase);
                tags.func_74782_a("ench", (NBTBase)enchants);
            } else {
                tags.func_82580_o("ench");
            }
            itemstack.func_77982_d(tags);
            itemstack.func_77972_a(5, (EntityLivingBase)player);
            player.func_71038_i();
            world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "thaumcraft:wandfail", 0.2f, 0.2f + world.field_73012_v.nextFloat() * 0.2f);
        }
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        NBTTagCompound tag = RandomUtils.getNBT(stack);
        return super.func_77653_i(stack) + " " + StatCollector.func_74838_a((String)"hammerz.keyword.phase") + " " + (tag.func_74771_c(this.PhaseKey) + 1);
    }
}

