/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.handlers.UpgradeManager;
import vapourdrive.hammerz.items.Hammer;
import vapourdrive.hammerz.utils.RandomUtils;

@Optional.Interface(modid="CoFHCore", iface="cofh.api.energy.IEnergyContainerItem", striprefs=true)
public class DarkHammer
extends Hammer
implements IEnergyContainerItem {
    public static final String Tag_Energy = "hammerz.hammer.energy";

    public DarkHammer(Item.ToolMaterial material, String Name) {
        super(material, Name);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityHit, EntityLivingBase player) {
        if (this.extractEnergy(stack, ConfigOptions.EIOToolEnergyuse, true) >= ConfigOptions.EIOToolEnergyuse) {
            this.extractEnergy(stack, ConfigOptions.EIOToolEnergyuse, false);
        } else {
            super.func_77644_a(stack, entityHit, player);
        }
        return true;
    }

    @Override
    public boolean handleDamage(Block breakBlock, ItemStack stack, EntityPlayer player) {
        if (DarkHammer.isEmpowered(stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                return this.attemptDamage(breakBlock, stack, UpgradeManager.getChance(DarkHammer.getEmpoweredment(stack)), player);
            }
            return true;
        }
        return super.handleDamage(breakBlock, stack, player);
    }

    public boolean attemptDamage(Block breakBlock, ItemStack stack, float chance, EntityPlayer player) {
        boolean wasEnergised = false;
        Random rand = new Random();
        if (rand.nextFloat() < chance) {
            if (breakBlock == Blocks.field_150343_Z) {
                if (this.extractEnergy(stack, ConfigOptions.EIOToolObsidianEnergyUse, true) >= ConfigOptions.EIOToolObsidianEnergyUse) {
                    this.extractEnergy(stack, ConfigOptions.EIOToolObsidianEnergyUse, false);
                    wasEnergised = true;
                    return true;
                }
            } else if (this.extractEnergy(stack, ConfigOptions.EIOToolEnergyuse, true) >= ConfigOptions.EIOToolEnergyuse) {
                this.extractEnergy(stack, ConfigOptions.EIOToolEnergyuse, false);
                wasEnergised = true;
                return true;
            }
        }
        if (!wasEnergised) {
            return super.handleDamage(breakBlock, stack, player);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        ItemStack stack = new ItemStack(item, 1, 0);
        NBTTagCompound tagCompound = RandomUtils.getNBT(stack);
        tagCompound.func_74768_a("hammerz.upgrade.empowerment", 4);
        tagCompound.func_74768_a(Tag_Energy, this.getMaxEnergyStored(stack));
        list.add(stack);
    }

    @Override
    public void addStandardInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        list.add(EnumChatFormatting.WHITE + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"phrase.hammerz.holdshift"));
    }

    @Override
    public void addExpandedInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        int power = DarkHammer.getEmpoweredment(stack);
        if (DarkHammer.isEmpowered(stack)) {
            this.addAdvancedInfo(power, stack, list);
            list.add(String.format("%,6d", this.getEnergyStored(stack)) + "/" + String.format("%,6d", this.getMaxEnergyStored(stack)) + " RF");
        }
        if (DarkHammer.getEmpoweredment(stack) < 4) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"enderio.tooltip.anvilupgrades"));
        }
        this.addUpgradeInfo(power, stack, list);
    }

    @Override
    public void addPermanentInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        int power = DarkHammer.getEmpoweredment(stack);
        this.addEmpowerInfo(power, stack, list);
    }

    public void addEmpowerInfo(int power, ItemStack stack, List list) {
        if (DarkHammer.isEmpowered(stack)) {
            String level = UpgradeManager.getNumberString(DarkHammer.getEmpoweredment(stack));
            list.add(EnumChatFormatting.DARK_AQUA + StatCollector.func_74838_a((String)("enderio.darksteel.upgrade.empowered_" + level + ".name")));
        }
    }

    private void addAdvancedInfo(int power, ItemStack stack, List list) {
        list.add("  " + EnumChatFormatting.WHITE + "+" + ConfigOptions.EIOToolEmpoweredSpeedBoost + " " + StatCollector.func_74838_a((String)"enderio.item.darkSteel_pickaxe.tooltip.effPowered"));
        list.add("  " + EnumChatFormatting.WHITE + "+" + ConfigOptions.EIOToolEmpoweredObsidianSpeedBoost + " " + StatCollector.func_74838_a((String)"enderio.item.darkSteel_pickaxe.tooltip.effObs"));
        list.add("    " + EnumChatFormatting.WHITE + "(" + ConfigOptions.EIOToolObsidianEnergyUse + " RF / block)");
        String str2 = StatCollector.func_74838_a((String)"enderio.darksteel.upgrade.empowered_one.tooltip.detailed.line2");
        String str3 = StatCollector.func_74838_a((String)"enderio.darksteel.upgrade.empowered_one.tooltip.detailed.line3");
        str2 = str2.replaceAll("\\$D", String.valueOf((int)(UpgradeManager.getChance(power) * 100.0f)));
        list.add(str2 + " " + str3);
    }

    public void addUpgradeInfo(int power, ItemStack stack, List list) {
        if (DarkHammer.getEmpoweredment(stack) < 4) {
            int level = DarkHammer.getEmpoweredment(stack);
            String levelString = UpgradeManager.getNumberString(level + 1);
            list.add(EnumChatFormatting.DARK_AQUA + StatCollector.func_74838_a((String)("enderio.darksteel.upgrade.empowered_" + levelString + ".name")) + ":");
            list.add("  " + EnumChatFormatting.DARK_AQUA + "" + EnumChatFormatting.ITALIC + UpgradeManager.getItem(level + 1).func_82833_r() + " + " + UpgradeManager.getXPCost(level + 1));
        }
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return this.receiveEnergy(container, maxReceive, simulate, true);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate, boolean restricted) {
        int energy = this.getEnergyStored(container);
        int energyRecieved = !restricted ? Math.min(this.getMaxEnergyStored(container) - energy, maxReceive) : Math.min(this.getMaxEnergyStored(container) - energy, Math.min(maxReceive, this.getMaxEnergyStored(container) / 1000));
        if (!simulate) {
            RandomUtils.getNBT(container).func_74768_a(Tag_Energy, energy += energyRecieved);
        }
        return energyRecieved;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int energy = this.getEnergyStored(container);
        int energyExtracted = Math.min(energy, maxExtract);
        if (!simulate) {
            RandomUtils.getNBT(container).func_74768_a(Tag_Energy, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        return RandomUtils.getNBT(container).func_74762_e(Tag_Energy);
    }

    public int getMaxEnergyStored(ItemStack container) {
        if (DarkHammer.isEmpowered(container)) {
            switch (RandomUtils.getNBT(container).func_74762_e("hammerz.upgrade.empowerment")) {
                case 1: {
                    return ConfigOptions.EIOToolBaseEnergy;
                }
                case 2: {
                    return ConfigOptions.EIOToolTierOneEnergy;
                }
                case 3: {
                    return ConfigOptions.EIOToolTierTwoEnergy;
                }
                case 4: {
                    return ConfigOptions.EIOToolTierThreeEnergy;
                }
            }
            return 0;
        }
        return 0;
    }

    public static boolean isEmpowered(ItemStack stack) {
        return DarkHammer.getEmpoweredment(stack) > 0;
    }

    public static int getEmpoweredment(ItemStack stack) {
        int level = RandomUtils.getNBT(stack).func_74762_e("hammerz.upgrade.empowerment");
        if (level > 0) {
            return level;
        }
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @Override
    public float getDigSpeed(ItemStack stack, IBlockState state) {
        float speed = this.field_77864_a * 0.3f;
        if (state.func_177230_c().isToolEffective("pickaxe", state) && DarkHammer.isEmpowered(stack)) {
            speed = (float)((double)speed + ConfigOptions.EIOToolEmpoweredSpeedBoost);
        }
        if (state.func_177230_c() == Blocks.field_150343_Z) {
            return (float)ConfigOptions.EIOToolEmpoweredObsidianSpeedBoost / 3.0f;
        }
        return super.getDigSpeed(stack, state) * 0.5f;
    }
}

