/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import thaumcraft.api.ThaumcraftMaterials;
import vapourdrive.hammerz.Hammerz;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.config.HammerzConfig;
import vapourdrive.hammerz.items.hammer.HammerModel;
import vapourdrive.hammerz.items.hammer.HammerType;
import vapourdrive.hammerz.items.hammer.ItemHammer;
import vapourdrive.hammerz.utils.RandomUtils;
import vazkii.botania.api.BotaniaAPI;

public class HZ_Items {
    public static ArrayList<HammerType> potentialHammerTypes = new ArrayList();
    public static ArrayList<HammerType> hammerTypes = new ArrayList();
    public static Item ItemHammer;

    public static void preInit() {
        HZ_Items.setupHammerTypes();
        HZ_Items.setupModHammerTypes();
    }

    public static void init() {
        ItemHammer = new ItemHammer();
    }

    public static void clientInit(FMLPreInitializationEvent event) {
        HammerModel.init();
    }

    public static void postInit() {
        HZ_Items.registerHammerTypes();
    }

    public static void setupHammerTypes() {
        HZ_Items.addHammerType(0, 0, "logWood", Item.ToolMaterial.WOOD, 0);
        HZ_Items.addHammerType(0, 0, "stone", Item.ToolMaterial.STONE, 1);
        HZ_Items.addHammerType(0, 0, "blockIron", Item.ToolMaterial.IRON, 2);
        HZ_Items.addHammerType(0, 0, "blockGold", Item.ToolMaterial.GOLD, 3);
        HZ_Items.addHammerType(0, 0, "blockDiamond", Item.ToolMaterial.EMERALD, 4);
        HZ_Items.addHammerType(0, 0, "blockCopper", "Copper", 1, 175, 4.0f, 0.5f, 6, 5);
        HZ_Items.addHammerType(0, 0, "blockTin", "Tin", 1, 200, 4.5f, 1.0f, 7, 6);
        HZ_Items.addHammerType(0, 0, "blockSilver", "Silver", 2, 200, 6.0f, 1.5f, 20, 7);
        HZ_Items.addHammerType(0, 0, "blockLead", "Lead", 1, 150, 5.0f, 1.0f, 9, 8);
        HZ_Items.addHammerType(0, 0, "blockNickel", "Nickel", 2, 300, 6.5f, 2.5f, 18, 9);
        HZ_Items.addHammerType(0, 0, "blockElectrum", "Electrum", 0, 100, 14.0f, 0.5f, 30, 10);
        HZ_Items.addHammerType(0, 0, "blockInvar", "Invar", 2, 450, 7.0f, 3.0f, 16, 11);
        HZ_Items.addHammerType(0, 0, "blockBronze", "Bronze", 2, 500, 6.0f, 2.0f, 15, 12);
        HZ_Items.addHammerType(0, 0, "blockPlatinum", "Platinum", 4, 1700, 9.0f, 4.0f, 9, 13);
        HZ_Items.addHammerType(0, 0, "blockSteel", "Steel", 2, 500, 7.0f, 2.0f, 9, 14);
    }

    private static void setupModHammerTypes() {
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            Hammerz.log.log(Level.INFO, "ThaumcraftCompat loading");
            HZ_Items.addHammerType(3, 0, "blockThaumium", ThaumcraftMaterials.TOOLMAT_THAUMIUM, 15);
            Hammerz.hasStorageBlock = true;
            if (Loader.isModLoaded((String)"ForbiddenMagic")) {
                Hammerz.log.log(Level.INFO, "Forbidden Magic Compat loading");
                HZ_Items.addHammerType(3, 0, "blockThaumium", ThaumcraftMaterials.TOOLMAT_ELEMENTAL, 16);
            }
        }
        if (Loader.isModLoaded((String)"Botania")) {
            Hammerz.log.log(Level.INFO, "BotaniaCompat loading");
            HZ_Items.addHammerType(1, 0, "blockManasteel", BotaniaAPI.manasteelToolMaterial, 17);
            HZ_Items.addHammerType(1, 0, "blockElvenElementium", BotaniaAPI.elementiumToolMaterial, 18);
        }
        if (Loader.isModLoaded((String)"EnderIO")) {
            Hammerz.log.log(Level.INFO, "EnderIOCompat loading");
            HZ_Items.addHammerType(2, 0, "blockDarkSteel", "DarkSteel", 5, 1561, 7.0f, 2.0f, 25, 19);
        }
        if (Loader.isModLoaded((String)"RotaryCraft")) {
            Hammerz.log.log(Level.INFO, "RotaryCraftCompat loading");
            HZ_Items.addHammerType(-1, 0, "blockBedRock", "Bedrock", 3, 0, 8.0f, 3.0f, 10, 20);
            HZ_Items.addHammerType(-1, 0, "blockHSLA", "HSLA", 2, 600, 6.0f, 3.0f, 14, 21);
        }
    }

    public static void registerHammerTypes() {
        Iterator<HammerType> iterator = potentialHammerTypes.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            HammerType type = iterator.next();
            if (ConfigOptions.OreDictHammerEnabling[i] && RandomUtils.doesOreNameExist(type.getBlockName())) {
                hammerTypes.add(potentialHammerTypes.get(i));
            }
            ++i;
        }
    }

    public static void addHammerType(int damageType, int maxEnergy, String blockName, Item.ToolMaterial material, int index) {
        String name = material.name();
        if (material == Item.ToolMaterial.EMERALD) {
            name = "DIAMOND";
        }
        int harvestLevel = material.func_77996_d();
        int durability = material.func_77997_a();
        float efficiency = material.func_77998_b();
        float damage = material.func_78000_c();
        int enchantability = material.func_77995_e();
        HammerType hammertype = new HammerType(damageType, maxEnergy, blockName, name, harvestLevel, durability, efficiency, damage, enchantability);
        potentialHammerTypes.add(hammertype);
        HammerzConfig.enabledOreDictHammersComment = HammerzConfig.enabledOreDictHammersComment + name + ", ";
        HammerzConfig.enabledOreDictHammersArrayList.add(true);
    }

    public static void addHammerType(int damageType, int maxEnergy, String blockName, String name, int harvestLevel, int durability, float efficiency, float damage, int enchantability, int index) {
        HammerType hammertype = new HammerType(damageType, maxEnergy, blockName, name.toUpperCase(), harvestLevel, durability, efficiency, damage, enchantability);
        potentialHammerTypes.add(hammertype);
        HammerzConfig.enabledOreDictHammersComment = HammerzConfig.enabledOreDictHammersComment + name + ", ";
        HammerzConfig.enabledOreDictHammersArrayList.add(true);
    }
}

