/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;
import vapourdrive.hammerz.Hammerz;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.proxies.CommonProxy;
import vapourdrive.hammerz.utils.RandomUtils;

public class Hammer
extends ItemPickaxe {
    public String name;

    public Hammer(Item.ToolMaterial material, String Name) {
        super(material);
        this.func_77655_b(Name + "Hammer");
        this.func_77637_a(CommonProxy.HZTab);
        this.func_77656_e((int)((float)this.func_77612_l() * ConfigOptions.DurabilityMultiplier));
        this.name = Name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        this.addPermanentInfo(stack, player, list, useExtraInformation);
        if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
            this.addExpandedInfo(stack, player, list, useExtraInformation);
        } else {
            this.addStandardInfo(stack, player, list, useExtraInformation);
        }
    }

    public void addStandardInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        list.add(EnumChatFormatting.WHITE + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"phrase.hammerz.holdshift"));
        if (ConfigOptions.AddDurabilityInfo) {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"hammerz.keyword.durability") + ": " + (stack.func_77958_k() - stack.func_77952_i()) + "/" + stack.func_77958_k());
        }
    }

    public void addExpandedInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"phrase.hammerz.hammerinfo1"));
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"phrase.hammerz.hammerinfo2"));
    }

    public void addPermanentInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (player.func_70093_af() && ConfigOptions.CanShiftMine || block.func_176195_g(world, pos) == 0.0f) {
            return false;
        }
        MovingObjectPosition object = RandomUtils.raytraceFromEntity(world, (Entity)player, false, 4.5);
        if (object == null) {
            return super.func_179218_a(stack, world, block, pos, (EntityLivingBase)player);
        }
        EnumFacing side = object.field_178784_b;
        int xmove = 0;
        int ymove = 0;
        int zmove = 0;
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            xmove = 1;
            zmove = 1;
        } else {
            ymove = 1;
            if (side == EnumFacing.WEST || side == EnumFacing.EAST) {
                zmove = 1;
            } else {
                xmove = 1;
            }
        }
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int i = -xmove; i <= xmove; ++i) {
            for (int j = -ymove; j <= ymove; ++j) {
                for (int k = -zmove; k <= zmove; ++k) {
                    if (x + i == x && y + j == y && z + k == z) continue;
                    this.checkBlockBreak(world, player, new BlockPos(x + i, y + j, z + k), stack, strength, block, side);
                }
            }
        }
        return false;
    }

    public void checkBlockBreak(World world, EntityPlayer player, BlockPos pos, ItemStack stack, float strength, Block originalBlock, EnumFacing side) {
        float newStrength;
        IBlockState state = world.func_180495_p(pos);
        Block breakBlock = state.func_177230_c();
        Material material = originalBlock.func_149688_o();
        if (breakBlock.func_149688_o() == material && ForgeHooks.canHarvestBlock((Block)breakBlock, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && stack.func_150998_b(breakBlock) && (newStrength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos)) > 0.0f && strength / newStrength <= 10.0f) {
            if ((double)breakBlock.func_176195_g(world, pos) != 0.0) {
                if (this.handleDamage(breakBlock, stack, player)) {
                    RandomUtils.breakBlock(world, state, pos, side, player);
                }
            } else {
                RandomUtils.breakBlock(world, state, pos, side, player);
            }
        }
    }

    public void log(World world, Object object) {
        if (world.field_72995_K) {
            Hammerz.log.log(Level.INFO, object);
        }
    }

    public boolean requestDamage(Block breakBlock, ItemStack stack, EntityPlayer player, int damage) {
        if (stack.func_77958_k() - stack.func_77952_i() < damage) {
            return false;
        }
        stack.func_77972_a(damage, (EntityLivingBase)player);
        return stack.field_77994_a != 0;
    }

    public boolean handleDamage(Block breakBlock, ItemStack stack, EntityPlayer player) {
        return this.requestDamage(breakBlock, stack, player, 1);
    }

    public float getDigSpeed(ItemStack stack, IBlockState state) {
        return super.getDigSpeed(stack, state) * ConfigOptions.EfficiencyMultiplier;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float floatx, float floaty, float floatz) {
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof Hammer) {
            if (!player.func_70093_af()) {
                ItemStack torchStack = new ItemStack(Blocks.field_150478_aa);
                if (player.field_71071_by.func_70431_c(torchStack)) {
                    torchStack.func_77973_b().func_180614_a(torchStack, player, world, pos, side, floatx, floaty, floatz);
                    player.field_71071_by.func_146026_a(torchStack.func_77973_b());
                    return true;
                }
            } else {
                return this.onItemShiftUse(stack, player, world, pos, side, floatx, floaty, floatz);
            }
        }
        return false;
    }

    public boolean onItemShiftUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float floatx, float floaty, float floatz) {
        return false;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack stack2) {
        int[] names = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int i = 0; i < names.length; ++i) {
            if (!("block" + this.name).contentEquals(OreDictionary.getOreName((int)names[i]))) continue;
            return true;
        }
        return false;
    }
}

