/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items.hammer;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.items.hammer.EnergyHandler;
import vapourdrive.hammerz.items.hammer.HammerInfoHandler;
import vazkii.botania.api.mana.ManaItemHandler;

public class DamageHandler {
    public static final int MANA_PER_DAMAGE = 60;

    public static boolean handleDamage(Block breakBlock, ItemStack stack, EntityPlayer player) {
        return DamageHandler.requestDamage(breakBlock, stack, player, 1);
    }

    public static boolean requestDamage(Block breakBlock, ItemStack stack, EntityPlayer player, int damage) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (!HammerInfoHandler.getTakesDamage(stack)) {
            return true;
        }
        if (HammerInfoHandler.getUsesMana(stack)) {
            return DamageHandler.handleManaDamage(stack, damage, player);
        }
        if (HammerInfoHandler.getUsesEnergy(stack)) {
            return DamageHandler.handleEnergyDamage(stack, damage, player);
        }
        return DamageHandler.handleRegularDamage(stack, damage, player);
    }

    private static boolean handleRegularDamage(ItemStack stack, int damage, EntityPlayer player) {
        if (stack.func_77958_k() - stack.func_77952_i() < damage) {
            return false;
        }
        stack.func_77972_a(damage, (EntityLivingBase)player);
        return stack.field_77994_a != 0;
    }

    private static boolean handleEnergyDamage(ItemStack stack, int damage, EntityPlayer player) {
        if (EnergyHandler.extractEnergy(stack, ConfigOptions.HammerEnergyUse * damage, true) < ConfigOptions.HammerEnergyUse * damage) {
            return DamageHandler.handleRegularDamage(stack, damage, player);
        }
        EnergyHandler.extractEnergy(stack, ConfigOptions.HammerEnergyUse * damage, false);
        return true;
    }

    private static boolean handleManaDamage(ItemStack stack, int damage, EntityPlayer player) {
        if (!ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)60, (boolean)true)) {
            return DamageHandler.handleRegularDamage(stack, damage, player);
        }
        return true;
    }

    public static boolean handleDamage(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return DamageHandler.requestDamage(null, stack, (EntityPlayer)attacker, 2);
    }
}

