/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items.hammer;

import net.minecraft.item.ItemStack;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.items.hammer.HammerInfoHandler;
import vapourdrive.hammerz.utils.RandomUtils;

public class EnergyHandler {
    public static int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        int energy = EnergyHandler.getEnergyStored(stack);
        int energyRecieved = Math.min(EnergyHandler.getMaxEnergyStored(stack) - energy, maxReceive);
        if (!simulate) {
            RandomUtils.getNBT(stack).func_74768_a("Hammerz.hammer.darkhammer.energy", energy += energyRecieved);
        }
        return energyRecieved;
    }

    public static int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        int energy = EnergyHandler.getEnergyStored(stack);
        int energyExtracted = Math.min(energy, maxExtract);
        if (!simulate) {
            energy -= energyExtracted;
            if (HammerInfoHandler.isDarkSteel(stack)) {
                RandomUtils.getNBT(stack).func_74768_a("Hammerz.hammer.darkhammer.energy", energy);
            } else {
                RandomUtils.getNBT(stack).func_74768_a("Hammerz.hammer.energy", energy);
            }
        }
        return energyExtracted;
    }

    public static int getEnergyStored(ItemStack stack) {
        if (HammerInfoHandler.isDarkSteel(stack)) {
            return RandomUtils.getNBT(stack).func_74762_e("Hammerz.hammer.darkhammer.energy");
        }
        return RandomUtils.getNBT(stack).func_74762_e("Hammerz.hammer.energy");
    }

    public static int getMaxEnergyStored(ItemStack stack) {
        if (HammerInfoHandler.isDarkSteel(stack) && EnergyHandler.isEmpowered(stack)) {
            switch (RandomUtils.getNBT(stack).func_74762_e("Hammerz.upgrade.empowerment")) {
                case 1: {
                    return ConfigOptions.EIOToolBaseEnergy;
                }
                case 2: {
                    return ConfigOptions.EIOToolTierOneEnergy;
                }
                case 3: {
                    return ConfigOptions.EIOToolTierTwoEnergy;
                }
                case 4: {
                    return ConfigOptions.EIOToolTierThreeEnergy;
                }
            }
            return 0;
        }
        return 0;
    }

    public static boolean isEmpowered(ItemStack stack) {
        return EnergyHandler.getEmpoweredment(stack) > 0;
    }

    public static int getEmpoweredment(ItemStack stack) {
        int level = RandomUtils.getNBT(stack).func_74762_e("Hammerz.upgrade.empowerment");
        if (level > 0) {
            return level;
        }
        return 0;
    }
}

