/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items.hammer;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.items.HZ_Items;
import vapourdrive.hammerz.items.hammer.HammerType;
import vapourdrive.hammerz.utils.RandomUtils;

public class HammerInfoHandler {
    public static int getHarvestLevel(ItemStack stack, String toolClass) {
        return HammerInfoHandler.getHammerType(stack).getHarvestLevel();
    }

    public static float getEfficiency(ItemStack stack) {
        return HammerInfoHandler.getHammerType(stack).getEfficiency();
    }

    public static int getItemEnchantability(ItemStack stack) {
        return HammerInfoHandler.getHammerType(stack).getEnchantability();
    }

    public static int getMaxDamage(ItemStack stack) {
        if (HammerInfoHandler.getHammerType(stack) == null) {
            return 100;
        }
        return (int)((float)HammerInfoHandler.getHammerType(stack).getDurability() * ConfigOptions.DurabilityMultiplier);
    }

    public static float getStrengthVsBlock(ItemStack stack, Block block) {
        return block.func_149688_o() != Material.field_151573_f && block.func_149688_o() != Material.field_151574_g && block.func_149688_o() != Material.field_151576_e ? 1.0f : HammerInfoHandler.getEfficiency(stack);
    }

    public static boolean getUsesMana(ItemStack stack) {
        return HammerInfoHandler.getHammerType(stack).getUsesMana();
    }

    public static boolean getUsesEnergy(ItemStack stack) {
        return HammerInfoHandler.getHammerType(stack).getUsesEnergy();
    }

    public static boolean canHarvestBlock(Block block, ItemStack stack) {
        return block == Blocks.field_150343_Z ? HammerInfoHandler.getHarvestLevel(stack, "pickaxe") == 3 : (block != Blocks.field_150484_ah && block != Blocks.field_150482_ag ? (block != Blocks.field_150412_bA && block != Blocks.field_150475_bE ? (block != Blocks.field_150340_R && block != Blocks.field_150352_o ? (block != Blocks.field_150339_S && block != Blocks.field_150366_p ? (block != Blocks.field_150368_y && block != Blocks.field_150369_x ? (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay ? (block.func_149688_o() == Material.field_151576_e ? true : (block.func_149688_o() == Material.field_151573_f ? true : block.func_149688_o() == Material.field_151574_g)) : HammerInfoHandler.getHarvestLevel(stack, "pickaxe") >= 2) : HammerInfoHandler.getHarvestLevel(stack, "pickaxe") >= 1) : HammerInfoHandler.getHarvestLevel(stack, "pickaxe") >= 1) : HammerInfoHandler.getHarvestLevel(stack, "pickaxe") >= 2) : HammerInfoHandler.getHarvestLevel(stack, "pickaxe") >= 2) : HammerInfoHandler.getHarvestLevel(stack, "pickaxe") >= 2);
    }

    public static HammerType getHammerType(ItemStack stack) {
        NBTTagCompound tagCompound = RandomUtils.getNBT(stack);
        String hammerTypeName = tagCompound.func_74779_i("Hammerz.HammerType");
        return HammerInfoHandler.getHammerType(hammerTypeName);
    }

    public static HammerType getHammerType(String hammerTypeName) {
        if (hammerTypeName != null) {
            for (HammerType type : HZ_Items.hammerTypes) {
                if (type == null || !type.getName().toLowerCase().contentEquals(hammerTypeName.toLowerCase())) continue;
                return type;
            }
        }
        return null;
    }

    public static boolean getTakesDamage(ItemStack stack) {
        return HammerInfoHandler.getHammerType(stack).getTakesDamage();
    }

    public static boolean isElemental(ItemStack stack) {
        return HammerInfoHandler.getHammerType(stack).getName().toLowerCase().contentEquals("elemental");
    }

    public static boolean isDarkSteel(ItemStack stack) {
        return HammerInfoHandler.getHammerType(stack).getName().toLowerCase().contentEquals("darksteel");
    }
}

