/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items.hammer;

import cofh.api.energy.IEnergyContainerItem;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.items.HZ_Items;
import vapourdrive.hammerz.items.hammer.AddInformationHelper;
import vapourdrive.hammerz.items.hammer.DamageHandler;
import vapourdrive.hammerz.items.hammer.EnergyHandler;
import vapourdrive.hammerz.items.hammer.HammerInfoHandler;
import vapourdrive.hammerz.items.hammer.HammerType;
import vapourdrive.hammerz.items.hammer.ItemUseHandler;
import vapourdrive.hammerz.items.hammer.OnUpdateHandler;
import vapourdrive.hammerz.items.hammer.RepairHandler;
import vapourdrive.hammerz.proxies.CommonProxy;
import vapourdrive.hammerz.utils.RandomUtils;
import vazkii.botania.api.mana.IManaUsingItem;

@Optional.InterfaceList(value={@Optional.Interface(modid="Botania", iface="vazkii.botania.api.mana.IManaUsingItem", striprefs=true), @Optional.Interface(modid="CoFHCore", iface="cofh.api.energy.IEnergyContainerItem", striprefs=true), @Optional.Interface(modid="Botania", iface="vazkii.botania.api.mana.ManaItemHandler", striprefs=true)})
public class ItemHammer
extends Item
implements IEnergyContainerItem,
IManaUsingItem {
    public static final String HammerKey = "Hammerz.HammerType";
    public static final String Tag_DarkSteelEnergy = "Hammerz.hammer.darkhammer.energy";
    public static final String Tag_EnergyStored = "Hammerz.hammer.energy";
    public static final String Key_Empower = "Hammerz.upgrade.empowerment";

    public ItemHammer() {
        this.func_77637_a(CommonProxy.HZTab);
        this.func_77655_b("Hammer");
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        AddInformationHelper.addInformation(stack, player, list, useExtraInformation);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public float getDigSpeed(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return HammerInfoHandler.getEfficiency(stack) * ConfigOptions.EfficiencyMultiplier;
        }
        return 1.0f;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float floatx, float floaty, float floatz) {
        if (!player.func_70093_af()) {
            return ItemUseHandler.onItemUse(stack, player, world, pos, side, floatx, floaty, floatz);
        }
        return ItemUseHandler.onItemShiftUse(stack, player, world, pos, side, floatx, floaty, floatz);
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        OnUpdateHandler.onUpdate(stack, world, player, par4, par5);
    }

    public boolean func_82789_a(ItemStack stack, ItemStack stack2) {
        return RepairHandler.getIsRepairable(stack, stack2);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return HammerInfoHandler.getHarvestLevel(stack, toolClass);
    }

    public int getItemEnchantability(ItemStack stack) {
        return HammerInfoHandler.getItemEnchantability(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return HammerInfoHandler.getMaxDamage(stack);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet ToolClass = Sets.newHashSet((Object[])new String[]{"pickaxe"});
        return ToolClass;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return HammerInfoHandler.canHarvestBlock(block, stack);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return HammerInfoHandler.getStrengthVsBlock(stack, block);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return DamageHandler.handleDamage(stack, target, attacker);
    }

    public boolean func_179218_a(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase player) {
        DamageHandler.handleDamage(block, stack, (EntityPlayer)player);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (player.func_70093_af() && ConfigOptions.CanShiftMine || block.func_176195_g(world, pos) == 0.0f) {
            return false;
        }
        MovingObjectPosition object = RandomUtils.raytraceFromEntity(world, (Entity)player, false, 4.5);
        if (object == null) {
            return super.func_179218_a(stack, world, block, pos, (EntityLivingBase)player);
        }
        EnumFacing side = object.field_178784_b;
        int xmove = 0;
        int ymove = 0;
        int zmove = 0;
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            xmove = 1;
            zmove = 1;
        } else {
            ymove = 1;
            if (side == EnumFacing.WEST || side == EnumFacing.EAST) {
                zmove = 1;
            } else {
                xmove = 1;
            }
        }
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int i = -xmove; i <= xmove; ++i) {
            for (int j = -ymove; j <= ymove; ++j) {
                for (int k = -zmove; k <= zmove; ++k) {
                    if (x + i == x && y + j == y && z + k == z) continue;
                    this.checkBlockBreak(world, player, new BlockPos(x + i, y + j, z + k), stack, strength, block, side);
                }
            }
        }
        return false;
    }

    public void checkBlockBreak(World world, EntityPlayer player, BlockPos pos, ItemStack stack, float strength, Block originalBlock, EnumFacing side) {
        float newStrength;
        IBlockState state = world.func_180495_p(pos);
        Block breakBlock = state.func_177230_c();
        Material material = originalBlock.func_149688_o();
        if (breakBlock.func_149688_o() == material && ForgeHooks.canHarvestBlock((Block)breakBlock, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && stack.func_150998_b(breakBlock) && (newStrength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos)) > 0.0f && strength / newStrength <= 10.0f) {
            if ((double)breakBlock.func_176195_g(world, pos) != 0.0) {
                if (DamageHandler.handleDamage(breakBlock, stack, player)) {
                    RandomUtils.breakBlock(world, state, pos, side, player);
                }
            } else {
                RandomUtils.breakBlock(world, state, pos, side, player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (HammerType hammerType : HZ_Items.hammerTypes) {
            ItemStack stack = new ItemStack(item);
            NBTTagCompound tagCompound = RandomUtils.getNBT(stack);
            tagCompound.func_74778_a(HammerKey, hammerType.getName());
            list.add(stack);
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        HammerType type = HammerInfoHandler.getHammerType(stack);
        if (type != null) {
            return StatCollector.func_74838_a((String)("item.hammer." + type.getName().toLowerCase() + ".name"));
        }
        return StatCollector.func_74838_a((String)"item.hammer.stone.name");
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        return EnergyHandler.receiveEnergy(stack, maxReceive, simulate);
    }

    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        return EnergyHandler.extractEnergy(stack, maxExtract, simulate);
    }

    public int getEnergyStored(ItemStack stack) {
        return EnergyHandler.getEnergyStored(stack);
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return EnergyHandler.getMaxEnergyStored(stack);
    }

    public boolean usesMana(ItemStack stack) {
        return HammerInfoHandler.getUsesMana(stack);
    }
}

