/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.utils;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import vapourdrive.hammerz.Hammerz;

public class RandomUtils {
    public static ItemStack getItemStackFromString(String ModId, String ItemStackName, int StackSize) {
        Item item = GameRegistry.findItem((String)ModId, (String)ItemStackName);
        if (item != null) {
            ItemStack stack = new ItemStack(item, StackSize);
            if (stack != null) {
                return stack;
            }
        } else {
            ItemStack stack;
            Block b = GameRegistry.findBlock((String)ModId, (String)ItemStackName);
            if (b != null && (stack = new ItemStack(b, StackSize)) != null) {
                return stack;
            }
        }
        Hammerz.log.log(Level.INFO, "Attempt to find: " + ModId + ", " + ItemStackName + " Failed");
        return null;
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = new Vec3(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    public static boolean breakBlock(World world, IBlockState state, BlockPos pos, EnumFacing side, EntityPlayer player) {
        ItemStack item;
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        if (!(item = player.func_71045_bC()).func_77973_b().getToolClasses(item).contains(block.getHarvestTool(state)) && !(item.func_77973_b().func_150893_a(item, block) > 1.0f)) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        int event = 0;
        if (playerMP != null && (event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                block.func_176208_a(world, pos, state, player);
            } else {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            }
            if (block.removedByPlayer(world, pos, player, false)) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(world, pos));
            } else {
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, side));
            }
            return true;
        }
        if (!world.field_72995_K) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(world, pos, player, true)) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, null);
                if (event != -1) {
                    block.func_180637_b(world, pos, event);
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, side));
        }
        return true;
    }

    public static NBTTagCompound getNBT(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean doesOreNameExist(String ore) {
        String[] registeredOresStrings = OreDictionary.getOreNames();
        for (int i = 0; i < registeredOresStrings.length; ++i) {
            if (!registeredOresStrings[i].contentEquals(ore)) continue;
            return true;
        }
        return false;
    }
}

