/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.gui;

import com.zerofall.ezstorage.EZStorage;
import com.zerofall.ezstorage.container.ContainerStorageCore;
import com.zerofall.ezstorage.network.MyMessage;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import com.zerofall.ezstorage.util.EZItemRenderer;
import com.zerofall.ezstorage.util.ItemGroup;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiStorageCore
extends GuiContainer {
    TileEntityStorageCore tileEntity;
    EZItemRenderer ezRenderer;
    int scrollRow = 0;
    private boolean isScrolling = false;
    private boolean wasClicking = false;
    private static final ResourceLocation creativeInventoryTabs = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation searchBar = new ResourceLocation("textures/gui/container/creative_inventory/tab_item_search.png");
    private float currentScroll;
    private GuiTextField searchField;
    private List<ItemGroup> filteredList;

    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 10, this.field_147009_r + 6, 80, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(20);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(true);
        this.searchField.func_146195_b(true);
        this.searchField.func_146180_a("");
        this.filteredList = new ArrayList<ItemGroup>(this.tileEntity.inventory.inventory);
    }

    public GuiStorageCore(EntityPlayer player, World world, int x, int y, int z) {
        super((Container)new ContainerStorageCore(player, world, x, y, z));
        this.tileEntity = (TileEntityStorageCore)world.func_175625_s(new BlockPos(x, y, z));
        this.field_146999_f = 195;
        this.field_147000_g = 222;
    }

    public GuiStorageCore(ContainerStorageCore containerStorageCore, World world, int x, int y, int z) {
        super((Container)containerStorageCore);
        this.tileEntity = (TileEntityStorageCore)world.func_175625_s(new BlockPos(x, y, z));
        this.field_146999_f = 195;
        this.field_147000_g = 222;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.getBackground());
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.searchField.func_146189_e(this.tileEntity.hasSearchBox);
        if (this.tileEntity.hasSearchBox) {
            this.field_146297_k.field_71446_o.func_110577_a(searchBar);
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 4, 80, 4, 90, 12);
            this.searchField.func_146194_f();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.handleScrolling(mouseX, mouseY);
        this.updateFilteredItems();
        DecimalFormat formatter = new DecimalFormat("#,###");
        String totalCount = formatter.format(this.tileEntity.inventory.getTotalCount());
        String max = formatter.format(this.tileEntity.inventory.maxItems);
        String amount = totalCount + "/" + max;
        int stringWidth = this.field_146289_q.func_78256_a(amount);
        if (stringWidth > 88) {
            float ScaleFactor = 0.7f;
            float RScaleFactor = 1.0f / ScaleFactor;
            GL11.glPushMatrix();
            GL11.glScaled((double)ScaleFactor, (double)ScaleFactor, (double)ScaleFactor);
            int X = (int)((187.0f - (float)stringWidth * ScaleFactor) * RScaleFactor);
            this.field_146289_q.func_78276_b(amount, X, 10, 0x404040);
            GL11.glPopMatrix();
        } else {
            this.field_146289_q.func_78276_b(amount, 187 - stringWidth, 6, 0x404040);
        }
        int x = 8;
        int y = 18;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        if (this.ezRenderer == null) {
            this.ezRenderer = new EZItemRenderer(this.field_146297_k.func_110434_K(), this.field_146296_j.func_175037_a().func_178083_a());
        }
        this.ezRenderer.field_77023_b = 200.0f;
        boolean finished = false;
        for (int i = 0; i < this.rowsVisible(); ++i) {
            x = 8;
            for (int j = 0; j < 9; ++j) {
                int index = i * 9 + j;
                if ((index = this.scrollRow * 9 + index) >= this.filteredList.size()) {
                    finished = true;
                    break;
                }
                ItemGroup group = this.filteredList.get(index);
                ItemStack stack = group.itemStack;
                FontRenderer font = null;
                if (stack != null) {
                    font = stack.func_77973_b().getFontRenderer(stack);
                }
                if (font == null) {
                    font = this.field_146289_q;
                }
                RenderHelper.func_74520_c();
                this.field_146296_j.func_180450_b(stack, x, y);
                this.ezRenderer.func_180453_a(font, stack, x, y, "" + group.count);
                x += 18;
            }
            if (finished) break;
            y += 18;
        }
        int i1 = 175;
        int k = 18;
        int l = k + 108;
        this.field_146297_k.func_110434_K().func_110577_a(creativeInventoryTabs);
        this.func_73729_b(i1, k + (int)((float)(l - k - 17) * this.currentScroll), 232, 0, 12, 15);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        Integer slot = this.getSlotAt(mouseX, mouseY);
        if (slot != null) {
            ItemGroup group;
            boolean mode = false;
            if (GuiScreen.func_146272_n()) {
                mode = true;
            }
            int index = this.tileEntity.inventory.slotCount();
            if (slot < this.filteredList.size() && (group = this.filteredList.get(slot)) != null) {
                index = this.tileEntity.inventory.inventory.indexOf(group);
                if (index < 0) {
                    return;
                }
                this.func_146285_a(group.itemStack, mouseX, mouseY);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode)) {
            if (this.tileEntity.hasSearchBox && this.searchField.func_146206_l() && this.searchField.func_146201_a(typedChar, keyCode)) {
                this.updateFilteredItems();
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
        if (keyCode == 63) {
            this.tileEntity.sortInventory();
        }
    }

    private void updateFilteredItems() {
        this.filteredList = new ArrayList<ItemGroup>(this.tileEntity.inventory.inventory);
        Iterator<ItemGroup> iterator = this.filteredList.iterator();
        String s1 = this.searchField.func_146179_b().toLowerCase();
        while (iterator.hasNext()) {
            ItemGroup group = iterator.next();
            ItemStack itemstack = group.itemStack;
            boolean flag = false;
            for (String s : itemstack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x)) {
                if (!s.toLowerCase().contains(s1)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            iterator.remove();
        }
    }

    private void handleScrolling(int mouseX, int mouseY) {
        boolean flag = Mouse.isButtonDown((int)0);
        int k = this.field_147003_i;
        int l = this.field_147009_r;
        int i1 = k + 175;
        int j1 = l + 18;
        int k1 = i1 + 14;
        int l1 = j1 + 108;
        if (!this.wasClicking && flag && mouseX >= i1 && mouseY >= j1 && mouseX < k1 && mouseY < l1) {
            this.isScrolling = true;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - j1) - 7.5f) / ((float)(l1 - j1) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        Integer slot = this.getSlotAt(mouseX, mouseY);
        if (slot != null) {
            ItemGroup group;
            int mode = 0;
            if (GuiScreen.func_146272_n()) {
                mode = 1;
            }
            int index = this.tileEntity.inventory.slotCount();
            if (slot < this.filteredList.size() && (group = this.filteredList.get(slot)) != null && (index = this.tileEntity.inventory.inventory.indexOf(group)) < 0) {
                return;
            }
            EZStorage.networkWrapper.sendToServer((IMessage)new MyMessage(index, mouseButton, mode));
            ContainerStorageCore container = (ContainerStorageCore)this.field_147002_h;
            container.customSlotClick(index, mouseButton, mode, (EntityPlayer)this.field_146297_k.field_71439_g);
        } else {
            int elementX = this.searchField.field_146209_f;
            int elementY = this.searchField.field_146210_g;
            if (mouseX >= elementX && mouseX <= elementX + this.searchField.field_146218_h && mouseY >= elementY && mouseY <= elementY + this.searchField.field_146219_i) {
                if (mouseButton == 1 || GuiScreen.func_146272_n()) {
                    this.searchField.func_146180_a("");
                }
                this.searchField.func_146195_b(true);
            } else {
                this.searchField.func_146195_b(false);
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private Integer getSlotAt(int x, int y) {
        int row;
        int column;
        int startX = this.field_147003_i + 8;
        int startY = this.field_147009_r + 18;
        int clickedX = x - startX;
        int clickedY = y - startY;
        if (clickedX > 0 && clickedY > 0 && (column = clickedX / 18) < 9 && (row = clickedY / 18) < this.rowsVisible()) {
            int slot = row * 9 + column + this.scrollRow * 9;
            return slot;
        }
        return null;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            int j = this.tileEntity.inventory.slotCount() / 9 - this.rowsVisible() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
        }
    }

    private void scrollTo(float scroll) {
        int i = (this.tileEntity.inventory.slotCount() + 8) / 9 - this.rowsVisible();
        int j = (int)((double)(scroll * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        this.scrollRow = j;
    }

    protected ResourceLocation getBackground() {
        return new ResourceLocation("ezstorage:textures/gui/storageScrollGui.png");
    }

    public int rowsVisible() {
        return 6;
    }
}

