/*
 * Decompiled with CFR 0.152.
 */
package panda.pumpkincarving;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMaterialMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import panda.pumpkincarving.PumpkinCarving;

public class BlockCarvedPumpkin
extends BlockHorizontal {
    private BlockPattern snowmanBasePattern;
    private BlockPattern snowmanPattern;
    private BlockPattern golemBasePattern;
    private BlockPattern golemPattern;
    private static final Predicate<IBlockState> IS_PUMPKIN = new Predicate<IBlockState>(){

        public boolean apply(@Nullable IBlockState state) {
            return state != null && (state.func_177230_c() == PumpkinCarving.carvedPumpkin || state.func_177230_c() == PumpkinCarving.carvedPumpkinLit);
        }
    };
    public static final PropertyInteger FACE = PropertyInteger.func_177719_a((String)"face", (int)0, (int)3);

    protected BlockCarvedPumpkin() {
        super(Material.field_151572_C, MapColor.field_151676_q);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)FACE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.trySpawnGolem(worldIn, pos);
    }

    public boolean canDispenserPlace(World worldIn, BlockPos pos) {
        return this.getSnowmanBasePattern().func_177681_a(worldIn, pos) != null || this.getGolemBasePattern().func_177681_a(worldIn, pos) != null;
    }

    private void trySpawnGolem(World worldIn, BlockPos pos) {
        block9: {
            BlockPattern.PatternHelper blockpattern$patternhelper;
            block8: {
                blockpattern$patternhelper = this.getSnowmanPattern().func_177681_a(worldIn, pos);
                if (blockpattern$patternhelper == null) break block8;
                for (int i = 0; i < this.getSnowmanPattern().func_177685_b(); ++i) {
                    BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(0, i, 0);
                    worldIn.func_180501_a(blockworldstate.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                }
                EntitySnowman entitysnowman = new EntitySnowman(worldIn);
                BlockPos blockpos1 = blockpattern$patternhelper.func_177670_a(0, 2, 0).func_177508_d();
                entitysnowman.func_70012_b((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.05, (double)blockpos1.func_177952_p() + 0.5, 0.0f, 0.0f);
                worldIn.func_72838_d((Entity)entitysnowman);
                for (int j = 0; j < 120; ++j) {
                    worldIn.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, (double)blockpos1.func_177958_n() + worldIn.field_73012_v.nextDouble(), (double)blockpos1.func_177956_o() + worldIn.field_73012_v.nextDouble() * 2.5, (double)blockpos1.func_177952_p() + worldIn.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                }
                for (int i1 = 0; i1 < this.getSnowmanPattern().func_177685_b(); ++i1) {
                    BlockWorldState blockworldstate1 = blockpattern$patternhelper.func_177670_a(0, i1, 0);
                    worldIn.func_175722_b(blockworldstate1.func_177508_d(), Blocks.field_150350_a);
                }
                break block9;
            }
            blockpattern$patternhelper = this.getGolemPattern().func_177681_a(worldIn, pos);
            if (blockpattern$patternhelper == null) break block9;
            for (int k = 0; k < this.getGolemPattern().func_177684_c(); ++k) {
                for (int l = 0; l < this.getGolemPattern().func_177685_b(); ++l) {
                    worldIn.func_180501_a(blockpattern$patternhelper.func_177670_a(k, l, 0).func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
            BlockPos blockpos = blockpattern$patternhelper.func_177670_a(1, 2, 0).func_177508_d();
            EntityIronGolem entityirongolem = new EntityIronGolem(worldIn);
            entityirongolem.func_70849_f(true);
            entityirongolem.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
            worldIn.func_72838_d((Entity)entityirongolem);
            for (int j1 = 0; j1 < 120; ++j1) {
                worldIn.func_175688_a(EnumParticleTypes.SNOWBALL, (double)blockpos.func_177958_n() + worldIn.field_73012_v.nextDouble(), (double)blockpos.func_177956_o() + worldIn.field_73012_v.nextDouble() * 3.9, (double)blockpos.func_177952_p() + worldIn.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
            for (int k1 = 0; k1 < this.getGolemPattern().func_177684_c(); ++k1) {
                for (int l1 = 0; l1 < this.getGolemPattern().func_177685_b(); ++l1) {
                    BlockWorldState blockworldstate2 = blockpattern$patternhelper.func_177670_a(k1, l1, 0);
                    worldIn.func_175722_b(blockworldstate2.func_177508_d(), Blocks.field_150350_a);
                }
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)FACE, (Comparable)Integer.valueOf(meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack stack) {
        IBlockState newstate = this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)FACE, (Comparable)Integer.valueOf(meta));
        System.out.println(meta);
        return newstate;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACE, (Comparable)Integer.valueOf(this.getActualMeta(meta))).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta % 4)));
    }

    public int getActualMeta(int meta) {
        if (meta >= 0 && meta <= 3) {
            return 0;
        }
        if (meta >= 4 && meta <= 7) {
            return 1;
        }
        if (meta >= 8 && meta <= 11) {
            return 2;
        }
        if (meta >= 12 && meta <= 15) {
            return 3;
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, FACE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() + (Integer)state.func_177229_b((IProperty)FACE) * 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 1));
        list.add(new ItemStack(itemIn, 1, 2));
        list.add(new ItemStack(itemIn, 1, 3));
    }

    protected BlockPattern getSnowmanBasePattern() {
        if (this.snowmanBasePattern == null) {
            this.snowmanBasePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{" ", "#", "#"}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150433_aE))).func_177661_b();
        }
        return this.snowmanBasePattern;
    }

    protected BlockPattern getSnowmanPattern() {
        if (this.snowmanPattern == null) {
            this.snowmanPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"^", "#", "#"}).func_177662_a('^', BlockWorldState.func_177510_a(IS_PUMPKIN)).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150433_aE))).func_177661_b();
        }
        return this.snowmanPattern;
    }

    protected BlockPattern getGolemBasePattern() {
        if (this.golemBasePattern == null) {
            this.golemBasePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~ ~", "###", "~#~"}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.golemBasePattern;
    }

    protected BlockPattern getGolemPattern() {
        if (this.golemPattern == null) {
            this.golemPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', BlockWorldState.func_177510_a(IS_PUMPKIN)).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.golemPattern;
    }
}

