/*
 * Decompiled with CFR 0.152.
 */
package panda.pumpkincarving;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.oredict.OreDictionary;
import panda.pumpkincarving.PumpkinCarving;

public class CarvingRecipe
implements IRecipe {
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;
    protected ItemStack output = null;
    protected Object[] input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = false;

    public CarvingRecipe(int i) {
        if (i == 0) {
            this.DoRecipe(new ItemStack(Item.func_150898_a((Block)PumpkinCarving.carvedPumpkin), 1, 0), "  ", "BA", Character.valueOf('A'), Blocks.field_150423_aK, Character.valueOf('B'), new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        } else if (i == 1) {
            this.DoRecipe(new ItemStack(Item.func_150898_a((Block)PumpkinCarving.carvedPumpkin), 1, 1), "B ", " A", Character.valueOf('A'), Blocks.field_150423_aK, Character.valueOf('B'), new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        } else if (i == 2) {
            this.DoRecipe(new ItemStack(Item.func_150898_a((Block)PumpkinCarving.carvedPumpkin), 1, 2), " B", " A", Character.valueOf('A'), Blocks.field_150423_aK, Character.valueOf('B'), new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        } else if (i == 3) {
            this.DoRecipe(new ItemStack(Item.func_150898_a((Block)PumpkinCarving.carvedPumpkin), 1, 3), " A", " B", Character.valueOf('A'), Blocks.field_150423_aK, Character.valueOf('B'), new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        } else if (i == 4) {
            this.DoRecipe(new ItemStack(Item.func_150898_a((Block)PumpkinCarving.carvedPumpkin2), 1, 0), " A", "B ", Character.valueOf('A'), Blocks.field_150423_aK, Character.valueOf('B'), new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        } else if (i == 5) {
            this.DoRecipe(new ItemStack(Item.func_150898_a((Block)PumpkinCarving.carvedPumpkin2), 1, 1), " B", "A ", Character.valueOf('A'), Blocks.field_150423_aK, Character.valueOf('B'), new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        } else if (i == 6) {
            this.DoRecipe(new ItemStack(Item.func_150898_a((Block)PumpkinCarving.carvedPumpkin2), 1, 2), "  ", "AB", Character.valueOf('A'), Blocks.field_150423_aK, Character.valueOf('B'), new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        } else if (i == 7) {
            this.DoRecipe(new ItemStack(Item.func_150898_a((Block)PumpkinCarving.carvedPumpkin2), 1, 3), "A ", " B", Character.valueOf('A'), Blocks.field_150423_aK, Character.valueOf('B'), new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        }
    }

    public void DoRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public Object[] getInput() {
        return this.input;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        ItemStack[] aitemstack = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack != null) {
                if (itemstack.func_77973_b() != Items.field_151097_aZ) continue;
                ItemStack shearscopy = itemstack.func_77946_l();
                if (shearscopy.func_96631_a(1, Minecraft.func_71410_x().field_71441_e.field_73012_v)) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)ForgeHooks.getCraftingPlayer(), (ItemStack)itemstack, null);
                    aitemstack[i] = null;
                    continue;
                }
                aitemstack[i] = shearscopy;
                continue;
            }
            aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return aitemstack;
    }
}

