/*
 * Decompiled with CFR 0.152.
 */
package com.jlgm.chatbox.client.gui;

import com.jlgm.chatbox.lib.ChatBoxConfigStorage;
import com.jlgm.chatbox.lib.ChatBoxTips;
import com.jlgm.chatbox.main.ChatBoxMain;
import com.jlgm.chatbox.network.ChatBoxMessage;
import com.jlgm.chatbox.network.ChatBoxPacketHandler;
import com.jlgm.chatbox.tileentity.TileEntityChatBox;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import scala.util.Random;

public class GuiChatBox
extends GuiScreen {
    private GuiTextField messageTextField;
    private GuiTextField radiusTextField;
    private GuiButton doneButton;
    private GuiButton cancelButton;
    private GuiButton nextTipButton;
    private static ResourceLocation texture;
    private final TileEntityChatBox tile;
    private int currentTip;

    public GuiChatBox(TileEntityChatBox chatBox) {
        texture = new ResourceLocation("jlgm_chatbox:textures/gui/test.png");
        this.tile = chatBox;
        Random rand = new Random();
        this.currentTip = rand.nextInt(ChatBoxTips.tips.length - 1);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.doneButton = new GuiButton(0, this.field_146294_l / 2 - 124 + 8, this.field_146295_m / 2 + 83 - 28, 60, 20, new TextComponentString(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])).func_150260_c());
        this.field_146292_n.add(this.doneButton);
        this.cancelButton = new GuiButton(1, this.field_146294_l / 2 + 124 - 68, this.field_146295_m / 2 + 83 - 28, 60, 20, new TextComponentString(I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])).func_150260_c());
        this.field_146292_n.add(this.cancelButton);
        this.nextTipButton = new GuiButton(2, this.field_146294_l / 2 - 124 + 76, this.field_146295_m / 2 + 83 - 28, this.field_146294_l / 2 + 124 - 76 - (this.field_146294_l / 2 - 124 + 76), 20, new TextComponentString(I18n.func_135052_a((String)"container.chatbox.nexttip", (Object[])new Object[0])).func_150260_c());
        this.field_146292_n.add(this.nextTipButton);
        this.messageTextField = new GuiTextField(1, this.field_146289_q, this.field_146294_l / 2 - 124 + 8, this.field_146295_m / 2 - 83 + 30, 232, 20);
        this.messageTextField.func_146203_f(100);
        this.messageTextField.func_146185_a(true);
        this.messageTextField.func_146195_b(true);
        this.messageTextField.func_146205_d(true);
        this.messageTextField.func_146180_a(this.tile.getMessage());
        this.radiusTextField = new GuiTextField(1, this.field_146289_q, this.field_146294_l / 2 - 124 + 8, this.field_146295_m / 2 - 83 + 66, 50, 20);
        this.radiusTextField.func_146203_f(9);
        this.radiusTextField.func_146185_a(true);
        this.radiusTextField.func_146195_b(false);
        this.radiusTextField.func_146205_d(true);
        this.radiusTextField.func_146180_a(String.valueOf(this.tile.getRadius()));
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.messageTextField.func_146206_l()) {
            this.messageTextField.func_146178_a();
        }
        if (this.radiusTextField.func_146206_l()) {
            this.radiusTextField.func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        ChatBoxConfigStorage configStorage = ChatBoxMain.configStorage;
        this.func_73729_b(this.field_146294_l / 2 - 124, this.field_146295_m / 2 - 83, 0, 0, 248, 166);
        this.field_146289_q.func_78276_b(new TextComponentString(I18n.func_135052_a((String)this.tile.func_70005_c_(), (Object[])new Object[0])).func_150260_c(), this.field_146294_l / 2 - 124 + 8, this.field_146295_m / 2 - 83 + 8, 0x404040);
        this.field_146289_q.func_78276_b(new TextComponentString(I18n.func_135052_a((String)"container.chatbox.message", (Object[])new Object[0])).func_150260_c() + ":", this.field_146294_l / 2 - 124 + 8, this.field_146295_m / 2 - 83 + 20, 0x404040);
        this.field_146289_q.func_78276_b(new TextComponentString(I18n.func_135052_a((String)"container.chatbox.radius", (Object[])new Object[0])).func_150260_c() + ":", this.field_146294_l / 2 - 124 + 8, this.field_146295_m / 2 - 83 + 54, 0x404040);
        this.field_146289_q.func_78276_b(configStorage.minRadius + " - " + configStorage.maxRadius, this.field_146294_l / 2 - 124 + 62, this.field_146295_m / 2 - 83 + 72, 0xA0A0A0);
        this.field_146289_q.func_78279_b(new TextComponentString(I18n.func_135052_a((String)ChatBoxTips.tips[this.currentTip], (Object[])new Object[0])).func_150260_c(), this.field_146294_l / 2 - 124 + 8, this.field_146295_m / 2 - 83 + 94, 232, 0xA0A0A0);
        this.messageTextField.func_146194_f();
        this.radiusTextField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.messageTextField.func_146201_a(typedChar, keyCode);
        if (Character.isDigit(typedChar) || Character.isISOControl(typedChar)) {
            this.radiusTextField.func_146201_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.messageTextField.func_146192_a(mouseX, mouseY, mouseButton);
        this.radiusTextField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.doneButton) {
            this.tile.setMessage(this.messageTextField.func_146179_b());
            int radius = Integer.valueOf(this.radiusTextField.func_146179_b());
            ChatBoxConfigStorage configStorage = ChatBoxMain.configStorage;
            if (radius < configStorage.minRadius) {
                radius = configStorage.minRadius;
            }
            if (radius > configStorage.maxRadius) {
                radius = configStorage.maxRadius;
            }
            this.tile.setRadius(radius);
            ChatBoxPacketHandler.INSTANCE.sendToServer((IMessage)new ChatBoxMessage(this.messageTextField.func_146179_b(), Integer.valueOf(this.radiusTextField.func_146179_b()), this.tile.func_174877_v()));
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (button == this.cancelButton) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (button == this.nextTipButton) {
            ++this.currentTip;
            if (this.currentTip >= ChatBoxTips.tips.length) {
                this.currentTip = 0;
            }
        }
    }
}

